/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.press;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.contraptions.components.press.BeltPressingCallbacks;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MechanicalPressTileEntity
extends BasinOperatingTileEntity {
    private static final Object compressingRecipesKey = new Object();
    public List<ItemStack> pressedItems = new ArrayList<ItemStack>();
    public BeltProcessingBehaviour processingBehaviour;
    public int prevRunningTicks;
    public int runningTicks;
    static final int CYCLE = 240;
    static final int ENTITY_SCAN = 10;
    int entityScanCooldown = 10;
    public boolean running;
    public Mode mode = Mode.WORLD;
    public boolean finished;
    private static final RecipeWrapper pressingInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
    private static final List<ResourceLocation> RECIPE_DENY_LIST = ImmutableList.of((Object)new ResourceLocation("occultism", "spirit_trade"), (Object)new ResourceLocation("occultism", "ritual"));

    public MechanicalPressTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour(this).whenItemEnters((s, i) -> BeltPressingCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> BeltPressingCallbacks.whenItemHeld(s, i, this));
        behaviours.add(this.processingBehaviour);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        this.running = compound.m_128471_("Running");
        this.mode = Mode.values()[compound.m_128451_("Mode")];
        this.finished = compound.m_128471_("Finished");
        this.prevRunningTicks = this.runningTicks = compound.m_128451_("Ticks");
        super.fromTag(compound, clientPacket);
        if (clientPacket) {
            NBTHelper.iterateCompoundList(compound.m_128437_("ParticleItems", 10), c -> this.pressedItems.add(ItemStack.m_41712_((CompoundTag)c)));
            this.spawnParticles();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Running", this.running);
        compound.m_128405_("Mode", this.mode.ordinal());
        compound.m_128379_("Finished", this.finished);
        compound.m_128405_("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.m_128365_("ParticleItems", (Tag)NBTHelper.writeCompoundList(this.pressedItems, IForgeItemStack::serializeNBT));
            this.pressedItems.clear();
        }
    }

    @Override
    public AABB makeRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0).m_82363_(0.0, 1.0, 0.0);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (!this.running) {
            return 0.0f;
        }
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.m_14179_((float)partialTicks, (float)this.prevRunningTicks, (float)runningTicks);
        if (runningTicks < 160) {
            return (float)Mth.m_14008_((double)Math.pow(ticks / 240.0f * 2.0f, 3.0), (double)0.0, (double)1.0) * this.mode.headOffset;
        }
        return Mth.m_14036_((float)((240.0f - ticks) / 240.0f * 3.0f), (float)0.0f, (float)1.0f) * this.mode.headOffset;
    }

    public void start(Mode mode) {
        this.mode = mode;
        this.running = true;
        this.prevRunningTicks = 0;
        this.runningTicks = 0;
        this.pressedItems.clear();
        this.sendData();
    }

    public boolean inWorld() {
        return this.mode == Mode.WORLD;
    }

    public boolean onBasin() {
        return this.mode == Mode.BASIN;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.running || this.f_58857_ == null) {
            if (this.m_58898_() && !this.f_58857_.f_46443_) {
                if (this.getSpeed() == 0.0f) {
                    return;
                }
                if (this.entityScanCooldown > 0) {
                    --this.entityScanCooldown;
                }
                if (this.entityScanCooldown <= 0) {
                    this.entityScanCooldown = 10;
                    if (TileEntityBehaviour.get((BlockGetter)this.f_58857_, this.f_58858_.m_6625_(2), TransportedItemStackHandlerBehaviour.TYPE) != null) {
                        return;
                    }
                    if (AllBlocks.BASIN.has(this.f_58857_.m_8055_(this.f_58858_.m_6625_(2)))) {
                        return;
                    }
                    for (ItemEntity itemEntity : this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_.m_7495_()).m_82406_(0.125))) {
                        ItemStack stack;
                        Optional<PressingRecipe> recipe;
                        if (!itemEntity.m_6084_() || !itemEntity.m_20096_() || !(recipe = this.getRecipe(stack = itemEntity.m_32055_())).isPresent()) continue;
                        this.start(Mode.WORLD);
                        return;
                    }
                }
            }
            return;
        }
        if (this.f_58857_.f_46443_ && this.runningTicks == -120) {
            this.prevRunningTicks = 120;
            return;
        }
        if (this.runningTicks == 120 && this.getSpeed() != 0.0f) {
            if (this.inWorld()) {
                this.applyPressingInWorld();
            }
            if (this.onBasin()) {
                this.applyCompactingOnBasin();
            }
            if (this.f_58857_.m_8055_(this.f_58858_.m_6625_(2)).m_60827_() == SoundType.f_56745_) {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION_ON_BELT.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
            } else {
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.5f, 0.75f + Math.abs(this.getSpeed()) / 1024.0f);
            }
            if (!this.f_58857_.f_46443_) {
                this.sendData();
            }
        }
        if (!this.f_58857_.f_46443_ && this.runningTicks > 240) {
            this.finished = true;
            this.running = false;
            if (this.onBasin() && this.matchBasinRecipe(this.currentRecipe) && this.getBasin().filter(BasinTileEntity::canContinueProcessing).isPresent()) {
                this.startProcessingBasin();
            } else {
                this.basinChecker.scheduleUpdate();
            }
            this.pressedItems.clear();
            this.sendData();
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        this.runningTicks += this.getRunningTickSpeed();
        if (this.prevRunningTicks < 120 && this.runningTicks >= 120) {
            this.runningTicks = 120;
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                this.runningTicks = -120;
            }
        }
    }

    protected void applyCompactingOnBasin() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.pressedItems.clear();
        this.applyBasinRecipe();
        Optional<BasinTileEntity> basin = this.getBasin();
        if (basin.isPresent()) {
            SmartInventory inputs = basin.get().getInputInventory();
            for (int slot = 0; slot < inputs.getSlots(); ++slot) {
                ItemStack stackInSlot = inputs.m_8020_(slot);
                if (stackInSlot.m_41619_()) continue;
                this.pressedItems.add(stackInSlot);
            }
        }
        this.sendData();
    }

    protected void applyPressingInWorld() {
        AABB bb = new AABB(this.f_58858_.m_6625_(1));
        boolean bulk = MechanicalPressTileEntity.canProcessInBulk();
        this.pressedItems.clear();
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (Entity entity : this.f_58857_.m_45933_(null, bb)) {
            if (!(entity instanceof ItemEntity) || !entity.m_6084_() || !entity.m_20096_()) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack item = itemEntity.m_32055_();
            this.pressedItems.add(item);
            this.sendData();
            Optional<PressingRecipe> recipe = this.getRecipe(item);
            if (!recipe.isPresent()) continue;
            if (bulk || item.m_41613_() == 1) {
                InWorldProcessing.applyRecipeOn(itemEntity, (Recipe)recipe.get());
            } else {
                for (ItemStack result : InWorldProcessing.applyRecipeOn(ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1), (Recipe)recipe.get())) {
                    ItemEntity created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
                    created.m_32060_();
                    created.m_20256_(VecHelper.offsetRandomly(Vec3.f_82478_, Create.RANDOM, 0.05f));
                    this.f_58857_.m_7967_((Entity)created);
                }
                item.m_41774_(1);
            }
            AllTriggers.triggerForNearbyPlayers(AllTriggers.BONK, (LevelAccessor)this.f_58857_, this.f_58858_, 4);
            this.entityScanCooldown = 0;
            if (bulk) continue;
            break;
        }
    }

    public static boolean canProcessInBulk() {
        return (Boolean)AllConfigs.SERVER.recipes.bulkPressing.get();
    }

    public int getRunningTickSpeed() {
        if (this.getSpeed() == 0.0f) {
            return 0;
        }
        return (int)Mth.m_14179_((float)Mth.m_14036_((float)(Math.abs(this.getSpeed()) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    protected void spawnParticles() {
        if (this.pressedItems.isEmpty()) {
            return;
        }
        if (this.mode == Mode.BASIN) {
            this.pressedItems.forEach(stack -> this.makeCompactingParticleEffect(VecHelper.getCenterOf((Vec3i)this.f_58858_.m_6625_(2)), (ItemStack)stack));
        }
        if (this.mode == Mode.BELT) {
            this.pressedItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)this.f_58858_.m_6625_(2)).m_82520_(0.0, 0.5, 0.0), (ItemStack)stack));
        }
        if (this.mode == Mode.WORLD) {
            this.pressedItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)this.f_58858_.m_6625_(1)).m_82520_(0.0, -0.25, 0.0), (ItemStack)stack));
        }
        this.pressedItems.clear();
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack) {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VecHelper.offsetRandomly(Vec3.f_82478_, this.f_58857_.f_46441_, 0.125f).m_82542_(1.0, 0.0, 1.0);
            this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_ - 0.25, pos.f_82481_, motion.f_82479_, motion.f_82480_ + 0.125, motion.f_82481_);
        }
    }

    public void makeCompactingParticleEffect(Vec3 pos, ItemStack stack) {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VecHelper.offsetRandomly(Vec3.f_82478_, this.f_58857_.f_46441_, 0.175f).m_82542_(1.0, 0.0, 1.0);
            this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_ + 0.25, motion.f_82481_);
        }
    }

    public Optional<PressingRecipe> getRecipe(ItemStack item) {
        Optional<PressingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(this.f_58857_, item, AllRecipeTypes.PRESSING.getType(), PressingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        pressingInv.m_6836_(0, item);
        return AllRecipeTypes.PRESSING.find(pressingInv, this.f_58857_);
    }

    public static <C extends Container> boolean canCompress(Recipe<C> recipe) {
        NonNullList ingredients = recipe.m_7527_();
        if (!(recipe instanceof CraftingRecipe)) {
            return false;
        }
        RecipeSerializer serializer = recipe.m_7707_();
        for (ResourceLocation denied : RECIPE_DENY_LIST) {
            if (serializer == null || !denied.equals((Object)serializer.getRegistryName())) continue;
            return false;
        }
        return (Boolean)AllConfigs.SERVER.recipes.allowShapedSquareInPress.get() != false && (ingredients.size() == 4 || ingredients.size() == 9) && ItemHelper.condenseIngredients((NonNullList<Ingredient>)ingredients).size() == 1;
    }

    @Override
    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe instanceof CraftingRecipe && !(recipe instanceof MechanicalCraftingRecipe) && MechanicalPressTileEntity.canCompress(recipe) && !AllRecipeTypes.isManualRecipe(recipe) || recipe.m_6671_() == AllRecipeTypes.COMPACTING.getType();
    }

    @Override
    protected Object getRecipeCacheKey() {
        return compressingRecipesKey;
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 120) {
            return;
        }
        super.startProcessingBasin();
        this.start(Mode.BASIN);
    }

    @Override
    protected void onBasinRemoved() {
        this.pressedItems.clear();
        this.running = false;
        this.runningTicks = 0;
        this.sendData();
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @Override
    protected Optional<ITriggerable> getProcessedRecipeTrigger() {
        return Optional.of(AllTriggers.PRESS_COMPACT);
    }

    public static enum Mode {
        WORLD(1.0f),
        BELT(1.1875f),
        BASIN(1.375f);

        float headOffset;

        private Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }
}

