/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.press;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressBlock;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;

public class PressInstance
extends ShaftInstance
implements IDynamicInstance {
    private final OrientedData pressHead;
    private final MechanicalPressTileEntity press;

    public PressInstance(MaterialManager dispatcher, MechanicalPressTileEntity tile) {
        super(dispatcher, tile);
        this.press = tile;
        this.pressHead = (OrientedData)dispatcher.defaultSolid().material(Materials.ORIENTED).getModel(AllBlockPartials.MECHANICAL_PRESS_HEAD, this.blockState).createInstance();
        Quaternion q = Vector3f.f_122225_.m_122240_(AngleHelper.horizontalAngle((Direction)this.blockState.m_61143_(MechanicalPressBlock.HORIZONTAL_FACING)));
        this.pressHead.setRotation(q);
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset(this.press);
        this.pressHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset(MechanicalPressTileEntity press) {
        return press.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks());
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new IFlatLight[]{this.pressHead});
    }

    @Override
    public void remove() {
        super.remove();
        this.pressHead.delete();
    }
}

