/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.AnchoredLighter;
import com.simibubi.create.foundation.config.AllConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class BearingContraption
extends Contraption {
    protected int sailBlocks;
    protected Direction facing;
    private boolean isWindmill;

    public BearingContraption() {
    }

    public BearingContraption(boolean isWindmill, Direction facing) {
        this.isWindmill = isWindmill;
        this.facing = facing;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        BlockPos offset = pos.m_142300_(this.facing);
        if (!this.searchMovedStructure(world, offset, null)) {
            return false;
        }
        this.startMoving(world);
        this.expandBoundsAroundAxis(this.facing.m_122434_());
        if (this.isWindmill && this.sailBlocks < (Integer)AllConfigs.SERVER.kinetics.minimumWindmillSails.get()) {
            throw AssemblyException.notEnoughSails(this.sailBlocks);
        }
        return !this.blocks.isEmpty();
    }

    @Override
    protected ContraptionType getType() {
        return ContraptionType.BEARING;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor.m_142300_(this.facing.m_122424_()));
    }

    @Override
    public void addBlock(BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture) {
        BlockPos localPos = pos.m_141950_((Vec3i)this.anchor);
        if (!this.getBlocks().containsKey(localPos) && AllTags.AllBlockTags.WINDMILL_SAILS.matches(((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_)) {
            ++this.sailBlocks;
        }
        super.addBlock(pos, capture);
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_("Sails", this.sailBlocks);
        tag.m_128405_("Facing", this.facing.m_122411_());
        return tag;
    }

    @Override
    public void readNBT(Level world, CompoundTag tag, boolean spawnData) {
        this.sailBlocks = tag.m_128451_("Sails");
        this.facing = Direction.m_122376_((int)tag.m_128451_("Facing"));
        super.readNBT(world, tag, spawnData);
    }

    public int getSailBlocks() {
        return this.sailBlocks;
    }

    public Direction getFacing() {
        return this.facing;
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        if (facing.m_122424_() == this.facing && BlockPos.f_121853_.equals((Object)localPos)) {
            return false;
        }
        return facing.m_122434_() == this.facing.m_122434_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new AnchoredLighter(this);
    }
}

