/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.BackHalfShaftInstance;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BearingInstance<B extends KineticTileEntity>
extends BackHalfShaftInstance
implements IDynamicInstance {
    final B bearing;
    final OrientedData topInstance;
    final Vector3f rotationAxis;
    final Quaternion blockOrientation;

    public BearingInstance(MaterialManager modelManager, B tile) {
        super(modelManager, (KineticTileEntity)tile);
        this.bearing = tile;
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.rotationAxis = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis).m_122432_();
        this.blockOrientation = BearingInstance.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingTileEntity)this.bearing).isWoodenTop() ? AllBlockPartials.BEARING_TOP_WOODEN : AllBlockPartials.BEARING_TOP;
        this.topInstance = (OrientedData)this.getOrientedMaterial().getModel(top, this.blockState).createInstance();
        this.topInstance.setPosition(this.getInstancePosition()).setRotation(this.blockOrientation);
    }

    public void beginFrame() {
        float interpolatedAngle = ((IBearingTileEntity)this.bearing).getInterpolatedAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Quaternion rot = this.rotationAxis.m_122240_(interpolatedAngle);
        rot.m_80148_(this.blockOrientation);
        this.topInstance.setRotation(rot);
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new IFlatLight[]{this.topInstance});
    }

    @Override
    public void remove() {
        super.remove();
        this.topInstance.delete();
    }

    static Quaternion getBlockStateOrientation(Direction facing) {
        Quaternion orientation = facing.m_122434_().m_122479_() ? Vector3f.f_122225_.m_122240_(AngleHelper.horizontalAngle(facing.m_122424_())) : Quaternion.f_80118_.m_80161_();
        orientation.m_80148_(Vector3f.f_122223_.m_122240_(-90.0f - AngleHelper.verticalAngle(facing)));
        return orientation;
    }
}

