/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BearingRenderer
extends KineticTileEntityRenderer {
    public BearingRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.getInstance().canUseInstancing(te.m_58904_())) {
            return;
        }
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        IBearingTileEntity bearingTe = (IBearingTileEntity)((Object)te);
        Direction facing = (Direction)te.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        PartialModel top = bearingTe.isWoodenTop() ? AllBlockPartials.BEARING_TOP_WOODEN : AllBlockPartials.BEARING_TOP;
        SuperByteBuffer superBuffer = CachedBufferer.partial(top, te.m_58900_());
        float interpolatedAngle = bearingTe.getInterpolatedAngle(partialTicks - 1.0f);
        BearingRenderer.kineticRotationTransform(superBuffer, te, facing.m_122434_(), (float)((double)(interpolatedAngle / 180.0f) * Math.PI), light);
        if (facing.m_122434_().m_122479_()) {
            superBuffer.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing.m_122424_())));
        }
        superBuffer.rotateCentered(Direction.EAST, AngleHelper.rad(-90.0f - AngleHelper.verticalAngle(facing)));
        superBuffer.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return CachedBufferer.partialFacing(AllBlockPartials.SHAFT_HALF, te.m_58900_(), ((Direction)te.m_58900_().m_61143_((Property)BearingBlock.FACING)).m_122424_());
    }
}

