/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.jozufozu.flywheel.backend.instancing.IInstanceRendered;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueItem;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class StickerTileEntity
extends SmartTileEntity
implements IInstanceRendered {
    LerpedFloat piston = LerpedFloat.linear();
    boolean update = false;

    public StickerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.f_58857_.f_46443_) {
            return;
        }
        this.piston.startWithValue(this.isBlockStateExtended() ? 1.0 : 0.0);
    }

    public boolean isBlockStateExtended() {
        BlockState blockState = this.m_58900_();
        boolean extended = AllBlocks.STICKER.has(blockState) && (Boolean)blockState.m_61143_((Property)StickerBlock.EXTENDED) != false;
        return extended;
    }

    @Override
    public void tick() {
        boolean target;
        super.tick();
        if (!this.f_58857_.f_46443_) {
            return;
        }
        this.piston.tickChaser();
        if (this.isAttachedToBlock() && this.piston.getValue(0.0f) != this.piston.getValue() && this.piston.getValue() == 1.0f) {
            SuperGlueItem.spawnParticles(this.f_58857_, this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)StickerBlock.f_52588_), true);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playSound(true));
        }
        if (!this.update) {
            return;
        }
        this.update = false;
        boolean bl = target = this.isBlockStateExtended();
        if (this.isAttachedToBlock() && !target && this.piston.getChaseTarget() == 1.0f) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playSound(false));
        }
        this.piston.chase((double)target, 0.4f, LerpedFloat.Chaser.LINEAR);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((BlockEntity)this));
    }

    public boolean isAttachedToBlock() {
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.STICKER.has(blockState)) {
            return false;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)StickerBlock.f_52588_);
        return SuperGlueEntity.isValidFace(this.f_58857_, this.f_58858_.m_142300_(direction), direction.m_122424_());
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        super.fromTag(compound, clientPacket);
        if (clientPacket) {
            this.update = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playSound(boolean attach) {
        AllSoundEvents.SLIME_ADDED.play(this.f_58857_, (Player)Minecraft.m_91087_().f_91074_, (Vec3i)this.f_58858_, 0.35f, attach ? 0.75f : 0.2f);
    }
}

