/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.instancing.ITickableInstance;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialGroup;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Formats;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.instancing.ConditionalInstance;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.core.model.IModel;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class GlueInstance
extends EntityInstance<SuperGlueEntity>
implements ITickableInstance {
    private static final boolean USE_ATLAS = false;
    private static final ResourceLocation TEXTURE = Create.asResource("textures/entity/super_glue/slime.png");
    private final Quaternion rotation;
    protected ConditionalInstance<OrientedData> model;

    public GlueInstance(MaterialManager materialManager, SuperGlueEntity entity) {
        super(materialManager, (Entity)entity);
        Instancer<OrientedData> instancer = this.getInstancer(materialManager, entity);
        Direction face = entity.getFacingDirection();
        this.rotation = new Quaternion(AngleHelper.verticalAngle(face), AngleHelper.horizontalAngle(face), 0.0f, true);
        this.model = new ConditionalInstance(instancer).withCondition(this::shouldShow).withSetupFunc(this::positionModel).update();
    }

    private Instancer<OrientedData> getInstancer(MaterialManager materialManager, SuperGlueEntity entity) {
        MaterialGroup group = materialManager.cutout(RenderType.m_110452_((ResourceLocation)TEXTURE));
        return group.material(Materials.ORIENTED).model((Object)entity.m_6095_(), GlueModel::new);
    }

    public void tick() {
        this.model.update();
    }

    public void remove() {
        this.model.delete();
    }

    private void positionModel(OrientedData model) {
        model.setPosition(this.getInstancePosition()).setPivot(0.0f, 0.0f, 0.0f).setRotation(this.rotation);
        this.updateLight(model);
    }

    public void updateLight() {
        this.model.get().ifPresent(this::updateLight);
    }

    private void updateLight(OrientedData model) {
        BlockPos pos = ((SuperGlueEntity)this.entity).getHangingPosition();
        model.setBlockLight(this.world.m_45517_(LightLayer.BLOCK, pos)).setSkyLight(this.world.m_45517_(LightLayer.SKY, pos));
    }

    private boolean shouldShow() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return ((SuperGlueEntity)this.entity).isVisible() || AllItems.SUPER_GLUE.isIn(player.m_21205_()) || AllItems.SUPER_GLUE.isIn(player.m_21206_());
    }

    public static class GlueModel
    implements IModel {
        public String name() {
            return "glue";
        }

        public void buffer(VertexConsumer buffer) {
            Vec3 diff = Vec3.m_82528_((Vec3i)Direction.SOUTH.m_122436_());
            Vec3 extension = diff.m_82541_().m_82490_(0.0234375);
            Vec3 plane = VecHelper.axisAlingedPlaneOf(diff);
            Direction.Axis axis = Direction.m_122366_((double)diff.f_82479_, (double)diff.f_82480_, (double)diff.f_82481_).m_122434_();
            Vec3 start = Vec3.f_82478_.m_82546_(extension);
            Vec3 end = Vec3.f_82478_.m_82549_(extension);
            plane = plane.m_82490_(0.5);
            Vec3 a1 = plane.m_82549_(start);
            Vec3 b1 = plane.m_82549_(end);
            plane = VecHelper.rotate(plane, -90.0, axis);
            Vec3 a2 = plane.m_82549_(start);
            Vec3 b2 = plane.m_82549_(end);
            plane = VecHelper.rotate(plane, -90.0, axis);
            Vec3 a3 = plane.m_82549_(start);
            Vec3 b3 = plane.m_82549_(end);
            plane = VecHelper.rotate(plane, -90.0, axis);
            Vec3 a4 = plane.m_82549_(start);
            Vec3 b4 = plane.m_82549_(end);
            float minV = 0.0f;
            float minU = 0.0f;
            float maxV = 1.0f;
            float maxU = 1.0f;
            buffer.m_5483_(a1.f_82479_, a1.f_82480_, a1.f_82481_).m_5601_(0.0f, 0.0f, -1.0f).m_7421_(maxU, minV).m_5752_();
            buffer.m_5483_(a2.f_82479_, a2.f_82480_, a2.f_82481_).m_5601_(0.0f, 0.0f, -1.0f).m_7421_(maxU, maxV).m_5752_();
            buffer.m_5483_(a3.f_82479_, a3.f_82480_, a3.f_82481_).m_5601_(0.0f, 0.0f, -1.0f).m_7421_(minU, maxV).m_5752_();
            buffer.m_5483_(a4.f_82479_, a4.f_82480_, a4.f_82481_).m_5601_(0.0f, 0.0f, -1.0f).m_7421_(minU, minV).m_5752_();
            buffer.m_5483_(b4.f_82479_, b4.f_82480_, b4.f_82481_).m_5601_(0.0f, 0.0f, 1.0f).m_7421_(minU, minV).m_5752_();
            buffer.m_5483_(b3.f_82479_, b3.f_82480_, b3.f_82481_).m_5601_(0.0f, 0.0f, 1.0f).m_7421_(minU, maxV).m_5752_();
            buffer.m_5483_(b2.f_82479_, b2.f_82480_, b2.f_82481_).m_5601_(0.0f, 0.0f, 1.0f).m_7421_(maxU, maxV).m_5752_();
            buffer.m_5483_(b1.f_82479_, b1.f_82480_, b1.f_82481_).m_5601_(0.0f, 0.0f, 1.0f).m_7421_(maxU, minV).m_5752_();
        }

        public int vertexCount() {
            return 8;
        }

        public VertexFormat format() {
            return Formats.UNLIT_MODEL;
        }
    }
}

