/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.DirectionalExtenderScrollOptionSlot;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.LinearActuatorTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonContraption;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MechanicalPistonTileEntity
extends LinearActuatorTileEntity {
    protected boolean hadCollisionWithOtherPiston;
    protected int extensionLength;

    public MechanicalPistonTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        this.extensionLength = compound.m_128451_("ExtensionLength");
        super.fromTag(compound, clientPacket);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128405_("ExtensionLength", this.extensionLength);
        super.write(tag, clientPacket);
    }

    @Override
    public void assemble() throws AssemblyException {
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof MechanicalPistonBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        PistonContraption contraption = new PistonContraption(direction, this.getMovementSpeed() < 0.0f);
        if (!contraption.assemble(this.f_58857_, this.f_58858_)) {
            return;
        }
        Direction positive = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)direction.m_122434_());
        Direction movementDirection = this.getSpeed() > 0.0f ^ direction.m_122434_() != Direction.Axis.Z ? positive : positive.m_122424_();
        BlockPos anchor = contraption.anchor.m_5484_(direction, contraption.initialExtensionProgress);
        if (ContraptionCollider.isCollidingWithWorld(this.f_58857_, contraption, anchor.m_142300_(movementDirection), movementDirection)) {
            return;
        }
        this.extensionLength = contraption.extensionLength;
        float resultingOffset = (float)contraption.initialExtensionProgress + Math.signum(this.getMovementSpeed()) * 0.5f;
        if (resultingOffset <= 0.0f || resultingOffset >= (float)this.extensionLength) {
            return;
        }
        this.running = true;
        this.offset = contraption.initialExtensionProgress;
        this.sendData();
        this.clientOffsetDiff = 0.0f;
        BlockPos startPos = BlockPos.f_121853_.m_5484_(direction, contraption.initialExtensionProgress);
        contraption.removeBlocksFromWorld(this.f_58857_, startPos);
        this.movedContraption = ControlledContraptionEntity.create(this.m_58904_(), this, contraption);
        this.resetContraptionToOffset();
        this.forceMove = true;
        this.f_58857_.m_7967_((Entity)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (!this.f_58859_) {
            this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.EXTENDED)), 19);
        }
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
        }
        this.running = false;
        this.movedContraption = null;
        this.sendData();
        if (this.f_58859_) {
            ((MechanicalPistonBlock)AllBlocks.MECHANICAL_PISTON.get()).m_5707_(this.f_58857_, this.f_58858_, this.m_58900_(), null);
        }
    }

    @Override
    protected void collided() {
        super.collided();
        if (!this.running && this.getMovementSpeed() > 0.0f) {
            this.assembleNextTick = true;
        }
    }

    @Override
    public float getMovementSpeed() {
        float movementSpeed = Mth.m_14036_((float)MechanicalPistonTileEntity.convertToLinear(this.getSpeed()), (float)-0.49f, (float)0.49f);
        if (this.f_58857_.f_46443_) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        Direction pistonDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        int movementModifier = pistonDirection.m_122421_().m_122540_() * (pistonDirection.m_122434_() == Direction.Axis.Z ? -1 : 1);
        movementSpeed = movementSpeed * (float)(-movementModifier) + this.clientOffsetDiff / 2.0f;
        int extensionRange = this.getExtensionRange();
        movementSpeed = Mth.m_14036_((float)movementSpeed, (float)(0.0f - this.offset), (float)((float)extensionRange - this.offset));
        return movementSpeed;
    }

    @Override
    protected int getExtensionRange() {
        return this.extensionLength;
    }

    @Override
    protected void visitNewPosition() {
    }

    @Override
    protected Vec3 toMotionVector(float speed) {
        Direction pistonDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        return Vec3.m_82528_((Vec3i)pistonDirection.m_122436_()).m_82490_((double)speed);
    }

    @Override
    protected Vec3 toPosition(float offset) {
        Vec3 position = Vec3.m_82528_((Vec3i)((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_()).m_82490_((double)offset);
        return position.m_82549_(Vec3.m_82528_((Vec3i)this.movedContraption.getContraption().anchor));
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new DirectionalExtenderScrollOptionSlot((state, d) -> {
            Direction.Axis axis = d.m_122434_();
            Direction.Axis extensionAxis = ((Direction)state.m_61143_((Property)MechanicalPistonBlock.FACING)).m_122434_();
            Direction.Axis shaftAxis = ((IRotate)state.m_60734_()).getRotationAxis((BlockState)state);
            return extensionAxis != axis && shaftAxis != axis;
        });
    }

    @Override
    protected int getInitialOffset() {
        return this.movedContraption == null ? 0 : ((PistonContraption)this.movedContraption.getContraption()).initialExtensionProgress;
    }
}

