/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.backend.instancing.tile.TileInstanceManager;
import com.jozufozu.flywheel.backend.material.MaterialManagerImpl;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.RenderedContraption;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.Pair;

public class ContraptionInstanceManager
extends TileInstanceManager {
    protected ArrayList<ActorInstance> actors = new ArrayList();
    private final WeakReference<RenderedContraption> contraption;

    ContraptionInstanceManager(RenderedContraption contraption, MaterialManagerImpl<?> materialManager) {
        super(materialManager);
        this.contraption = new WeakReference<RenderedContraption>(contraption);
    }

    public void tick() {
        this.actors.forEach(ActorInstance::tick);
    }

    public void beginFrame(Camera info) {
        super.beginFrame(info);
        this.actors.forEach(ActorInstance::beginFrame);
    }

    protected boolean shouldFrameUpdate(BlockPos worldPos, float lookX, float lookY, float lookZ, int cX, int cY, int cZ) {
        return true;
    }

    @Nullable
    public ActorInstance createActor(Pair<StructureTemplate.StructureBlockInfo, MovementContext> actor) {
        StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)actor.getLeft();
        MovementContext context = (MovementContext)actor.getRight();
        MovementBehaviour movementBehaviour = AllMovementBehaviours.of(blockInfo.f_74676_);
        if (movementBehaviour != null && movementBehaviour.hasSpecialInstancedRendering()) {
            ActorInstance instance = movementBehaviour.createInstance(this.materialManager, this.getContraption().renderWorld, context);
            this.actors.add(instance);
            return instance;
        }
        return null;
    }

    public RenderedContraption getContraption() {
        return (RenderedContraption)this.contraption.get();
    }
}

