/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.material.MaterialManagerImpl;
import com.jozufozu.flywheel.backend.model.ArrayModelRenderer;
import com.jozufozu.flywheel.backend.model.ModelRenderer;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.core.model.WorldModel;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionGroup;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionInstanceManager;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionProgram;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderInfo;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RenderedContraption
extends ContraptionRenderInfo {
    private final ContraptionLighter<?> lighter;
    public final MaterialManagerImpl<ContraptionProgram> materialManager;
    public final ContraptionInstanceManager kinetics;
    private final Map<RenderType, ModelRenderer> renderLayers = new HashMap<RenderType, ModelRenderer>();
    private final Matrix4f modelViewPartial = new Matrix4f();
    private boolean modelViewPartialReady;
    private AABB lightBox;

    public RenderedContraption(Contraption contraption, PlacementSimulationWorld renderWorld) {
        super(contraption, renderWorld);
        this.lighter = contraption.makeLighter();
        this.materialManager = MaterialManagerImpl.builder(CreateContexts.CWORLD).setGroupFactory(ContraptionGroup.forContraption(this)).setIgnoreOriginCoordinate(true).build();
        this.kinetics = new ContraptionInstanceManager(this, this.materialManager);
        this.buildLayers();
        if (Backend.getInstance().canUseInstancing()) {
            this.buildInstancedTiles();
            this.buildActors();
        }
    }

    public ContraptionLighter<?> getLighter() {
        return this.lighter;
    }

    public void doRenderLayer(RenderType layer, ContraptionProgram shader) {
        ModelRenderer structure = this.renderLayers.get(layer);
        if (structure != null) {
            this.setup(shader);
            structure.draw();
        }
    }

    @Override
    public void beginFrame(BeginFrameEvent event) {
        super.beginFrame(event);
        this.modelViewPartial.m_27624_();
        this.modelViewPartialReady = false;
        if (!this.isVisible()) {
            return;
        }
        this.kinetics.beginFrame(event.getInfo());
        Vec3 cameraPos = event.getCameraPos();
        this.lightBox = this.lighter.lightVolume.toAABB().m_82386_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
    }

    @Override
    public void setupMatrices(PoseStack viewProjection, double camX, double camY, double camZ) {
        super.setupMatrices(viewProjection, camX, camY, camZ);
        if (!this.modelViewPartialReady) {
            RenderedContraption.setupModelViewPartial(this.modelViewPartial, this.getMatrices().getModel().m_85850_().m_85861_(), this.contraption.entity, camX, camY, camZ, AnimationTickHolder.getPartialTicks());
            this.modelViewPartialReady = true;
        }
    }

    void setup(ContraptionProgram shader) {
        if (!this.modelViewPartialReady || this.lightBox == null) {
            return;
        }
        shader.bind(this.modelViewPartial, this.lightBox);
        this.lighter.lightVolume.bind();
    }

    @Override
    public void invalidate() {
        for (ModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        this.lighter.delete();
        this.materialManager.delete();
        this.kinetics.invalidate();
    }

    private void buildLayers() {
        for (ModelRenderer buffer : this.renderLayers.values()) {
            buffer.delete();
        }
        this.renderLayers.clear();
        List blockLayers = RenderType.m_110506_();
        for (RenderType layer : blockLayers) {
            Supplier<IModel> layerModel = () -> new WorldModel((BlockAndTintGetter)this.renderWorld, layer, this.contraption.getBlocks().values(), layer + "_" + this.contraption.entity.m_142049_());
            Object renderer = Backend.getInstance().compat.vertexArrayObjectsSupported() ? new ArrayModelRenderer(layerModel) : new ModelRenderer(layerModel);
            this.renderLayers.put(layer, (ModelRenderer)renderer);
        }
    }

    private void buildInstancedTiles() {
        List<BlockEntity> tileEntities = this.contraption.maybeInstancedTileEntities;
        if (!tileEntities.isEmpty()) {
            for (BlockEntity te : tileEntities) {
                if (!InstancedRenderRegistry.getInstance().canInstance(te.m_58903_())) continue;
                Level world = te.m_58904_();
                te.m_142339_((Level)this.renderWorld);
                this.kinetics.add(te);
                te.m_142339_(world);
            }
        }
    }

    private void buildActors() {
        this.contraption.getActors().forEach(this.kinetics::createActor);
    }

    public static void setupModelViewPartial(Matrix4f matrix, Matrix4f modelMatrix, AbstractContraptionEntity entity, double camX, double camY, double camZ, float pt) {
        float x = (float)(Mth.m_14139_((double)pt, (double)entity.f_19790_, (double)entity.m_20185_()) - camX);
        float y = (float)(Mth.m_14139_((double)pt, (double)entity.f_19791_, (double)entity.m_20186_()) - camY);
        float z = (float)(Mth.m_14139_((double)pt, (double)entity.f_19792_, (double)entity.m_20189_()) - camZ);
        matrix.setTranslation(x, y, z);
        matrix.m_27644_(modelMatrix);
    }
}

