/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.sync;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class ContraptionInteractionPacket
extends SimplePacketBase {
    private InteractionHand interactionHand;
    private int target;
    private BlockPos localPos;
    private Direction face;

    public ContraptionInteractionPacket(AbstractContraptionEntity target, InteractionHand hand, BlockPos localPos, Direction side) {
        this.interactionHand = hand;
        this.localPos = localPos;
        this.target = target.m_142049_();
        this.face = side;
    }

    public ContraptionInteractionPacket(FriendlyByteBuf buffer) {
        this.target = buffer.readInt();
        int handId = buffer.readInt();
        this.interactionHand = handId == -1 ? null : InteractionHand.values()[handId];
        this.localPos = buffer.m_130135_();
        this.face = Direction.m_122376_((int)buffer.readShort());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.target);
        buffer.writeInt(this.interactionHand == null ? -1 : this.interactionHand.ordinal());
        buffer.m_130064_(this.localPos);
        buffer.writeShort(this.face.m_122411_());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            Entity entityByID = sender.m_9236_().m_6815_(this.target);
            if (!(entityByID instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entityByID;
            double d = sender.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 10.0;
            if (!sender.m_142582_(entityByID)) {
                d -= 3.0;
            }
            d *= d;
            if (sender.m_20280_(entityByID) > d) {
                return;
            }
            if (contraptionEntity.handlePlayerInteraction((Player)sender, this.localPos, this.face, this.interactionHand)) {
                sender.m_21011_(this.interactionHand, true);
            }
        });
        context.get().setPacketHandled(true);
    }
}

