/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.waterwheel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.waterwheel.WaterWheelBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class WaterWheelTileEntity
extends GeneratingKineticTileEntity {
    private Map<Direction, Float> flows = new HashMap<Direction, Float>();

    public WaterWheelTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (Direction d : Iterate.directions) {
            this.setFlow(d, 0.0f);
        }
        this.setLazyTickRate(20);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        super.fromTag(compound, clientPacket);
        if (compound.m_128441_("Flows")) {
            for (Direction d : Iterate.directions) {
                this.setFlow(d, compound.m_128469_("Flows").m_128457_(d.m_7912_()));
            }
        }
    }

    @Override
    public AABB makeRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(1.0);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        CompoundTag flows = new CompoundTag();
        for (Direction d : Iterate.directions) {
            flows.m_128350_(d.m_7912_(), this.flows.get(d).floatValue());
        }
        compound.m_128365_("Flows", (Tag)flows);
        super.write(compound, clientPacket);
    }

    public void setFlow(Direction direction, float speed) {
        this.flows.put(direction, Float.valueOf(speed));
        this.m_6596_();
    }

    @Override
    public float getGeneratedSpeed() {
        float speed = 0.0f;
        for (Float f : this.flows.values()) {
            speed += f.floatValue();
        }
        if (speed != 0.0f) {
            speed += (float)((Integer)AllConfigs.SERVER.kinetics.waterWheelBaseSpeed.get()).intValue() * Math.signum(speed);
        }
        return speed;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        ((WaterWheelBlock)AllBlocks.WATER_WHEEL.get()).updateAllSides(this.m_58900_(), this.f_58857_, this.f_58858_);
    }
}

