/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.PipeConnection;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PumpTileEntity
extends KineticTileEntity {
    LerpedFloat arrowDirection = LerpedFloat.linear().startWithValue(1.0);
    Couple<MutableBoolean> sidesToUpdate = Couple.create(MutableBoolean::new);
    boolean pressureUpdate;
    boolean reversed;

    public PumpTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new PumpFluidTransferBehaviour(this));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reversed = this.getSpeed() < 0.0f;
    }

    @Override
    public void tick() {
        super.tick();
        float speed = this.getSpeed();
        if (this.f_58857_.f_46443_) {
            if (speed == 0.0f) {
                return;
            }
            this.arrowDirection.chase(speed >= 0.0f ? 1.0 : -1.0, 0.5, LerpedFloat.Chaser.EXP);
            this.arrowDirection.tickChaser();
            if (!this.isVirtual()) {
                return;
            }
        }
        this.sidesToUpdate.forEachWithContext((update, isFront) -> {
            if (update.isFalse()) {
                return;
            }
            update.setFalse();
            this.distributePressureTo(isFront != false ? this.getFront() : this.getFront().m_122424_());
        });
        if (speed == 0.0f) {
            return;
        }
        if (speed < 0.0f != this.reversed) {
            this.reversed = speed < 0.0f;
            this.updatePressureChange();
            return;
        }
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (previousSpeed == this.getSpeed()) {
            return;
        }
        if (this.speed != 0.0f) {
            boolean bl = this.reversed = this.speed < 0.0f;
        }
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        this.updatePressureChange();
    }

    public void updatePressureChange() {
        this.pressureUpdate = false;
        BlockPos frontPos = this.f_58858_.m_142300_(this.getFront());
        BlockPos backPos = this.f_58858_.m_142300_(this.getFront().m_122424_());
        FluidPropagator.propagateChangedPipe((LevelAccessor)this.f_58857_, frontPos, this.f_58857_.m_8055_(frontPos));
        FluidPropagator.propagateChangedPipe((LevelAccessor)this.f_58857_, backPos, this.f_58857_.m_8055_(backPos));
        FluidTransportBehaviour behaviour = this.getBehaviour(FluidTransportBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.wipePressure();
        }
        this.sidesToUpdate.forEach(MutableBoolean::setTrue);
    }

    protected void distributePressureTo(Direction side) {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockFace start = new BlockFace(this.f_58858_, side);
        boolean pull = this.isPullingOnSide(this.isFront(side));
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<BlockPos, Pair<Integer, Map<Direction, Boolean>>> pipeGraph = new HashMap<BlockPos, Pair<Integer, Map<Direction, Boolean>>>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks(this.f_58857_, this.f_58858_, side.m_122424_());
        }
        if (!this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.f_58858_, $ -> Pair.of(0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of(1, new IdentityHashMap())).getSecond()).put(side.m_122424_(), !pull);
            ArrayList<Pair<Integer, BlockPos>> frontier = new ArrayList<Pair<Integer, BlockPos>>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            int maxDistance = FluidPropagator.getPumpRange();
            frontier.add(Pair.of(1, start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                BlockPos currentPos = (BlockPos)entry.getSecond();
                if (!this.f_58857_.isAreaLoaded(currentPos, 0) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                BlockState currentState = this.f_58857_.m_8055_(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)this.f_58857_, currentPos);
                if (pipe == null) continue;
                for (Direction face : FluidPropagator.getPipeConnections(currentState, pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    BlockPos connectedPos = blockFace.getConnectedPos();
                    if (!this.f_58857_.isAreaLoaded(connectedPos, 0) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint((LevelAccessor)this.f_58857_, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, connectedPos);
                    if (pipeBehaviour == null || pipeBehaviour instanceof PumpFluidTransferBehaviour || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of(distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of(distance + 1, new IdentityHashMap())).getSecond()).put(face.m_122424_(), !pull);
                    frontier.add(Pair.of(distance + 1, connectedPos));
                }
            }
        }
        HashMap<Integer, Set<BlockFace>> validFaces = new HashMap<Integer, Set<BlockFace>>();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        float pressure = Math.abs(this.getSpeed());
        for (Set set : validFaces.values()) {
            int parallelBranches = set.size();
            for (BlockFace face : set) {
                BlockPos pipePos = face.getPos();
                Direction pipeSide = face.getFace();
                if (pipePos.equals((Object)this.f_58858_)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.f_58857_, pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)parallelBranches);
            }
        }
    }

    protected boolean searchForEndpointRecursively(Map<BlockPos, Pair<Integer, Map<Direction, Boolean>>> pipeGraph, Set<BlockFace> targets, Map<Integer, Set<BlockFace>> validFaces, BlockFace currentFace, boolean pull) {
        BlockPos currentPos = currentFace.getPos();
        if (!pipeGraph.containsKey(currentPos)) {
            return false;
        }
        Pair<Integer, Map<Direction, Boolean>> pair = pipeGraph.get(currentPos);
        int distance = pair.getFirst();
        boolean atLeastOneBranchSuccessful = false;
        for (Direction nextFacing : Iterate.directions) {
            Map<Direction, Boolean> map;
            if (nextFacing == currentFace.getFace() || !(map = pair.getSecond()).containsKey(nextFacing)) continue;
            BlockFace localTarget = new BlockFace(currentPos, nextFacing);
            if (targets.contains(localTarget)) {
                validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
                atLeastOneBranchSuccessful = true;
                continue;
            }
            if (map.get(nextFacing) != pull || !this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(currentPos.m_142300_(nextFacing), nextFacing.m_122424_()), pull)) continue;
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
            atLeastOneBranchSuccessful = true;
        }
        if (atLeastOneBranchSuccessful) {
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(currentFace);
        }
        return atLeastOneBranchSuccessful;
    }

    private boolean hasReachedValidEndpoint(LevelAccessor world, BlockFace blockFace, boolean pull) {
        LazyOptional capability;
        BlockPos connectedPos = blockFace.getConnectedPos();
        BlockState connectedState = world.m_8055_(connectedPos);
        BlockEntity tileEntity = world.m_7702_(connectedPos);
        Direction face = blockFace.getFace();
        if (PumpBlock.isPump(connectedState) && ((Direction)connectedState.m_61143_((Property)PumpBlock.FACING)).m_122434_() == face.m_122434_() && tileEntity instanceof PumpTileEntity) {
            PumpTileEntity pumpTE = (PumpTileEntity)tileEntity;
            return pumpTE.isPullingOnSide(pumpTE.isFront(blockFace.getOppositeFace())) != pull;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)world, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (tileEntity != null && (capability = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.m_122424_())).isPresent()) {
            return true;
        }
        return FluidPropagator.isOpenEnd((BlockGetter)world, blockFace.getPos(), face);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Reversed", this.reversed);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        this.reversed = compound.m_128471_("Reversed");
        super.fromTag(compound, clientPacket);
    }

    public void updatePipesOnSide(Direction side) {
        if (!this.isSideAccessible(side)) {
            return;
        }
        this.updatePipeNetwork(this.isFront(side));
        this.getBehaviour(FluidTransportBehaviour.TYPE).wipePressure();
    }

    protected boolean isFront(Direction side) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof PumpBlock)) {
            return false;
        }
        Direction front = (Direction)blockState.m_61143_((Property)PumpBlock.FACING);
        boolean isFront = side == front;
        return isFront;
    }

    @Nullable
    protected Direction getFront() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof PumpBlock)) {
            return null;
        }
        return (Direction)blockState.m_61143_((Property)PumpBlock.FACING);
    }

    protected void updatePipeNetwork(boolean front) {
        this.sidesToUpdate.get(front).setTrue();
    }

    public boolean isSideAccessible(Direction side) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof PumpBlock)) {
            return false;
        }
        return ((Direction)blockState.m_61143_((Property)PumpBlock.FACING)).m_122434_() == side.m_122434_();
    }

    public boolean isPullingOnSide(boolean front) {
        return front == this.reversed;
    }

    public boolean shouldRenderNormally() {
        return true;
    }

    class PumpFluidTransferBehaviour
    extends FluidTransportBehaviour {
        public PumpFluidTransferBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public void tick() {
            super.tick();
            for (Map.Entry entry : this.interfaces.entrySet()) {
                boolean pull = PumpTileEntity.this.isPullingOnSide(PumpTileEntity.this.isFront((Direction)entry.getKey()));
                Couple<Float> pressure = ((PipeConnection)entry.getValue()).pressure;
                pressure.set(pull, Float.valueOf(Math.abs(PumpTileEntity.this.getSpeed())));
                pressure.set(!pull, Float.valueOf(0.0f));
            }
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return PumpTileEntity.this.isSideAccessible(direction);
        }

        @Override
        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            return attachment;
        }
    }
}

