/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.IAxisPipe;
import com.simibubi.create.content.contraptions.fluids.pipes.SmartFluidPipeTileEntity;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.TickPriority;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmartFluidPipeBlock
extends FaceAttachedHorizontalDirectionalBlock
implements ITE<SmartFluidPipeTileEntity>,
IAxisPipe,
IWrenchable {
    public SmartFluidPipeBlock(BlockBehaviour.Properties p_i48339_1_) {
        super(p_i48339_1_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_53179_}).m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState stateForPlacement = super.m_5573_(ctx);
        Direction.Axis prefferedAxis = null;
        BlockPos pos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        for (Direction side : Iterate.directions) {
            if (!this.prefersConnectionTo((LevelReader)world, pos, side)) continue;
            if (prefferedAxis != null && prefferedAxis != side.m_122434_()) {
                prefferedAxis = null;
                break;
            }
            prefferedAxis = side.m_122434_();
        }
        if (prefferedAxis == Direction.Axis.Y) {
            stateForPlacement = (BlockState)((BlockState)stateForPlacement.m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)((Direction)stateForPlacement.m_61143_((Property)f_54117_)).m_122424_());
        } else if (prefferedAxis != null) {
            if (stateForPlacement.m_61143_((Property)f_53179_) == AttachFace.WALL) {
                stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR);
            }
            for (Direction direction : ctx.m_6232_()) {
                if (direction.m_122434_() != prefferedAxis) continue;
                stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
            }
        }
        return stateForPlacement;
    }

    protected boolean prefersConnectionTo(LevelReader reader, BlockPos pos, Direction facing) {
        BlockPos offset = pos.m_142300_(facing);
        BlockState blockState = reader.m_8055_(offset);
        return FluidPipeBlock.canConnectTo((BlockAndTintGetter)reader, offset, blockState, facing);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.m_60734_() != newState.m_60734_();
        if (blockTypeChanged && !world.f_46443_) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
        }
        if (state.m_155947_() && (blockTypeChanged || !newState.m_155947_())) {
            world.m_46747_(pos);
        }
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return true;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        if (state != oldState) {
            world.m_6219_().m_7663_(pos, (Object)this, 1, TickPriority.HIGH);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!SmartFluidPipeBlock.isOpenAt(state, d)) {
            return;
        }
        world.m_6219_().m_7663_(pos, (Object)this, 1, TickPriority.HIGH);
    }

    public static boolean isOpenAt(BlockState state, Direction d) {
        return d.m_122434_() == SmartFluidPipeBlock.getPipeAxis(state);
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random r) {
        FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
    }

    protected static Direction.Axis getPipeAxis(BlockState state) {
        return state.m_61143_((Property)f_53179_) == AttachFace.WALL ? Direction.Axis.Y : ((Direction)state.m_61143_((Property)f_54117_)).m_122434_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        AttachFace face = (AttachFace)state.m_61143_((Property)f_53179_);
        VoxelShaper shape = face == AttachFace.FLOOR ? AllShapes.SMART_FLUID_PIPE_FLOOR : (face == AttachFace.CEILING ? AllShapes.SMART_FLUID_PIPE_CEILING : AllShapes.SMART_FLUID_PIPE_WALL);
        return shape.get((Direction)state.m_61143_((Property)f_54117_));
    }

    @Override
    public Direction.Axis getAxis(BlockState state) {
        return SmartFluidPipeBlock.getPipeAxis(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public Class<SmartFluidPipeTileEntity> getTileEntityClass() {
        return SmartFluidPipeTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends SmartFluidPipeTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.SMART_FLUID_PIPE.get();
    }
}

