/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.recipe;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.ISimpleReloadListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionMixingRecipeManager {
    public static Map<Item, List<MixingRecipe>> ALL = new HashMap<Item, List<MixingRecipe>>();
    public static final ISimpleReloadListener LISTENER = (resourceManager, profiler) -> {
        ALL.clear();
        PotionMixingRecipeManager.getAllBrewingRecipes().forEach(recipe -> {
            Iterator iterator = recipe.m_7527_().iterator();
            while (iterator.hasNext()) {
                int n = 0;
                Ingredient ingredient = (Ingredient)iterator.next();
                ItemStack[] itemStackArray = ingredient.m_43908_();
                int n2 = itemStackArray.length;
                if (n >= n2) continue;
                ItemStack itemStack = itemStackArray[n];
                ALL.computeIfAbsent(itemStack.m_41720_(), t -> new ArrayList()).add(recipe);
                return;
            }
        });
    };

    public static List<MixingRecipe> getAllBrewingRecipes() {
        ArrayList<MixingRecipe> mixingRecipes = new ArrayList<MixingRecipe>();
        for (IBrewingRecipe iBrewingRecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(iBrewingRecipe instanceof VanillaBrewingRecipe)) continue;
            ArrayList bottles = new ArrayList();
            PotionBrewing.f_43496_.forEach(i -> {
                for (ItemStack itemStack : i.m_43908_()) {
                    bottles.add(itemStack);
                }
            });
            Collection<ItemStack> reagents = PotionMixingRecipeManager.getAllReagents(iBrewingRecipe);
            HashSet<ItemStack> basicPotions = new HashSet<ItemStack>();
            for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
                if (potion == Potions.f_43598_) continue;
                for (ItemStack stack : bottles) {
                    basicPotions.add(PotionUtils.m_43549_((ItemStack)stack.m_41777_(), (Potion)potion));
                }
            }
            HashSet<CallSite> uniqueKeys = new HashSet<CallSite>();
            ArrayList<Object> potionFrontier = new ArrayList<Object>();
            ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
            potionFrontier.addAll(basicPotions);
            int recipeIndex = 0;
            while (!potionFrontier.isEmpty()) {
                newPotions.clear();
                for (ItemStack itemStack : potionFrontier) {
                    Potion inputPotion = PotionUtils.m_43579_((ItemStack)itemStack);
                    for (ItemStack potionReagent : reagents) {
                        Potion outputPotion;
                        String uniqueKey;
                        ItemStack outputPotionStack = iBrewingRecipe.getOutput(itemStack.m_41777_(), potionReagent);
                        if (outputPotionStack.m_41619_() || !uniqueKeys.add((CallSite)((Object)(uniqueKey = potionReagent.m_41720_().getRegistryName().toString() + "_" + inputPotion.getRegistryName().toString() + "_" + itemStack.m_41720_().getRegistryName().toString()))) || itemStack.m_41720_() == outputPotionStack.m_41720_() && (outputPotion = PotionUtils.m_43579_((ItemStack)outputPotionStack)) == Potions.f_43599_) continue;
                        FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(itemStack);
                        FluidStack fluidFromPotionItem2 = PotionFluidHandler.getFluidFromPotionItem(outputPotionStack);
                        fluidFromPotionItem.setAmount(1000);
                        fluidFromPotionItem2.setAmount(1000);
                        MixingRecipe mixingRecipe = new ProcessingRecipeBuilder<MixingRecipe>(MixingRecipe::new, Create.asResource("potion_" + recipeIndex++)).require(Ingredient.m_43927_((ItemStack[])new ItemStack[]{potionReagent})).require(FluidIngredient.fromFluidStack(fluidFromPotionItem)).output(fluidFromPotionItem2).requiresHeat(HeatCondition.HEATED).build();
                        mixingRecipes.add(mixingRecipe);
                        newPotions.add(outputPotionStack);
                    }
                }
                potionFrontier.clear();
                potionFrontier.addAll(newPotions);
            }
            break block0;
        }
        return mixingRecipes;
    }

    public static Collection<ItemStack> getAllReagents(IBrewingRecipe recipe) {
        return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(arg_0 -> ((IBrewingRecipe)recipe).isIngredient(arg_0)).collect(Collectors.toList());
    }
}

