/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.particle;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.contraptions.particle.AirFlowParticleData;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class AirFlowParticle
extends SimpleAnimatedParticle {
    private final IAirCurrentSource source;

    protected AirFlowParticle(ClientLevel world, IAirCurrentSource source, double x, double y, double z, SpriteSet sprite) {
        super(world, x, y, z, sprite, world.f_46441_.nextFloat() * 0.5f);
        this.source = source;
        this.f_107663_ *= 0.75f;
        this.f_107225_ = 40;
        this.f_107219_ = false;
        this.selectSprite(7);
        Vec3 offset = VecHelper.offsetRandomly(Vec3.f_82478_, Create.RANDOM, 0.25f);
        this.m_107264_(x + offset.f_82479_, y + offset.f_82480_, z + offset.f_82481_);
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
        this.m_107271_(0.25f);
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.source == null || this.source.isSourceRemoved()) {
            this.dissipate();
            return;
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            double distance;
            if (this.source.getAirCurrent() == null || !this.source.getAirCurrent().bounds.m_82400_(0.25).m_82393_(this.f_107212_, this.f_107213_, this.f_107214_)) {
                this.dissipate();
                return;
            }
            Vec3 directionVec = Vec3.m_82528_((Vec3i)this.source.getAirCurrent().direction.m_122436_());
            Vec3 motion = directionVec.m_82490_(0.125);
            if (!this.source.getAirCurrent().pushing) {
                motion = motion.m_82490_(-1.0);
            }
            if ((distance = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82546_(VecHelper.getCenterOf((Vec3i)this.source.getAirCurrentPos())).m_82559_(directionVec).m_82553_() - 0.5) > (double)(this.source.getAirCurrent().maxDistance + 1.0f) || distance < -0.25) {
                this.dissipate();
                return;
            }
            motion = motion.m_82490_((double)this.source.getAirCurrent().maxDistance - (distance - 1.0)).m_82490_(0.5);
            this.selectSprite((int)Mth.m_14008_((double)(distance / (double)this.source.getAirCurrent().maxDistance * 8.0 + (double)this.f_107208_.f_46441_.nextInt(4)), (double)0.0, (double)7.0));
            this.morphType(distance);
            this.f_107215_ = motion.f_82479_;
            this.f_107216_ = motion.f_82480_;
            this.f_107217_ = motion.f_82481_;
            if (this.f_107218_) {
                this.f_107215_ *= 0.7;
                this.f_107217_ *= 0.7;
            }
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
    }

    public void morphType(double distance) {
        if (this.source.getAirCurrent() == null) {
            return;
        }
        InWorldProcessing.Type type = this.source.getAirCurrent().getSegmentAt((float)distance);
        if (type == InWorldProcessing.Type.SPLASHING) {
            this.m_107657_(Color.mixColors(0x4499FF, 0x2277FF, this.f_107208_.f_46441_.nextFloat()));
            this.m_107271_(1.0f);
            this.selectSprite(this.f_107208_.f_46441_.nextInt(3));
            if (this.f_107208_.f_46441_.nextFloat() < 0.03125f) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_ * 0.125, this.f_107216_ * 0.125, this.f_107217_ * 0.125);
            }
            if (this.f_107208_.f_46441_.nextFloat() < 0.03125f) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123772_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_ * 0.125, this.f_107216_ * 0.125, this.f_107217_ * 0.125);
            }
        }
        if (type == InWorldProcessing.Type.SMOKING) {
            this.m_107657_(Color.mixColors(0, 0x555555, this.f_107208_.f_46441_.nextFloat()));
            this.m_107271_(1.0f);
            this.selectSprite(this.f_107208_.f_46441_.nextInt(3));
            if (this.f_107208_.f_46441_.nextFloat() < 0.03125f) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_ * 0.125, this.f_107216_ * 0.125, this.f_107217_ * 0.125);
            }
            if (this.f_107208_.f_46441_.nextFloat() < 0.03125f) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_ * 0.125, this.f_107216_ * 0.125, this.f_107217_ * 0.125);
            }
        }
        if (type == InWorldProcessing.Type.BLASTING) {
            this.m_107657_(Color.mixColors(0xFF4400, 0xFF8855, this.f_107208_.f_46441_.nextFloat()));
            this.m_107271_(0.5f);
            this.selectSprite(this.f_107208_.f_46441_.nextInt(3));
            if (this.f_107208_.f_46441_.nextFloat() < 0.03125f) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_ * 0.25, this.f_107216_ * 0.25, this.f_107217_ * 0.25);
            }
            if (this.f_107208_.f_46441_.nextFloat() < 0.0625f) {
                this.f_107208_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49991_.m_49966_()), this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_ * 0.25, this.f_107216_ * 0.25, this.f_107217_ * 0.25);
            }
        }
        if (type == null) {
            this.m_107657_(0xEEEEEE);
            this.m_107271_(0.25f);
            this.m_107250_(0.2f, 0.2f);
        }
    }

    private void dissipate() {
        this.m_107274_();
    }

    public int m_6355_(float partialTick) {
        BlockPos blockpos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
        return this.f_107208_.m_46749_(blockpos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)blockpos) : 0;
    }

    private void selectSprite(int index) {
        this.m_108337_(this.f_107644_.m_5819_(index, 8));
    }

    public static class Factory
    implements ParticleProvider<AirFlowParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(AirFlowParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BlockEntity te = worldIn.m_7702_(new BlockPos(data.posX, data.posY, data.posZ));
            if (!(te instanceof IAirCurrentSource)) {
                te = null;
            }
            return new AirFlowParticle(worldIn, (IAirCurrentSource)te, x, y, z, this.spriteSet);
        }
    }
}

