/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class InWorldProcessing {
    private static final RecipeWrapper WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
    private static final SplashingWrapper SPLASHING_WRAPPER = new SplashingWrapper();

    public static boolean canProcess(ItemEntity entity, Type type) {
        CompoundTag compound;
        if (entity.getPersistentData().m_128441_("CreateData") && (compound = entity.getPersistentData().m_128469_("CreateData")).m_128441_("Processing")) {
            CompoundTag processing = compound.m_128469_("Processing");
            if (Type.valueOf(processing.m_128461_("Type")) != type) {
                boolean canProcess = InWorldProcessing.canProcess(entity.m_32055_(), type, entity.f_19853_);
                processing.m_128359_("Type", type.name());
                if (!canProcess) {
                    processing.m_128405_("Time", -1);
                }
                return canProcess;
            }
            if (processing.m_128451_("Time") >= 0) {
                return true;
            }
            if (processing.m_128451_("Time") == -1) {
                return false;
            }
        }
        return InWorldProcessing.canProcess(entity.m_32055_(), type, entity.f_19853_);
    }

    private static boolean canProcess(ItemStack stack, Type type, Level world) {
        if (type == Type.BLASTING) {
            WRAPPER.m_6836_(0, stack);
            Optional smeltingRecipe = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)WRAPPER, world);
            if (smeltingRecipe.isPresent()) {
                return true;
            }
            WRAPPER.m_6836_(0, stack);
            Optional blastingRecipe = world.m_7465_().m_44015_(RecipeType.f_44109_, (Container)WRAPPER, world);
            if (blastingRecipe.isPresent()) {
                return true;
            }
            return !stack.m_41720_().m_41475_();
        }
        if (type == Type.SMOKING) {
            WRAPPER.m_6836_(0, stack);
            Optional recipe = world.m_7465_().m_44015_(RecipeType.f_44110_, (Container)WRAPPER, world);
            return recipe.isPresent();
        }
        if (type == Type.SPLASHING) {
            return InWorldProcessing.isWashable(stack, world);
        }
        return false;
    }

    public static boolean isWashable(ItemStack stack, Level world) {
        SPLASHING_WRAPPER.m_6836_(0, stack);
        Optional recipe = AllRecipeTypes.SPLASHING.find(SPLASHING_WRAPPER, world);
        return recipe.isPresent();
    }

    public static void applyProcessing(ItemEntity entity, Type type) {
        if (InWorldProcessing.decrementProcessingTime(entity, type) != 0) {
            return;
        }
        List<ItemStack> stacks = InWorldProcessing.process(entity.m_32055_(), type, entity.f_19853_);
        if (stacks == null) {
            return;
        }
        if (stacks.isEmpty()) {
            entity.m_146870_();
            return;
        }
        entity.m_32045_(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), additional);
            entityIn.m_20256_(entity.m_20184_());
            entity.f_19853_.m_7967_((Entity)entityIn);
        }
    }

    public static TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(TransportedItemStack transported, Level world, Type type) {
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            int processingTime;
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.m_41613_() - 1) / 16 + 1;
            transported.processingTime = processingTime = (Integer)AllConfigs.SERVER.kinetics.inWorldProcessingTime.get() * timeModifierForStackSize + 1;
            if (!InWorldProcessing.canProcess(transported.stack, type, world)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        List<ItemStack> stacks = InWorldProcessing.process(transported.stack, type, world);
        if (stacks == null) {
            return ignore;
        }
        ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
        for (ItemStack additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.m_41777_();
            transportedStacks.add(newTransported);
        }
        return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
    }

    private static List<ItemStack> process(ItemStack stack, Type type, Level world) {
        if (type == Type.SPLASHING) {
            SPLASHING_WRAPPER.m_6836_(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find(SPLASHING_WRAPPER, world);
            if (recipe.isPresent()) {
                return InWorldProcessing.applyRecipeOn(stack, (Recipe)recipe.get());
            }
            return null;
        }
        WRAPPER.m_6836_(0, stack);
        Optional smokingRecipe = world.m_7465_().m_44015_(RecipeType.f_44110_, (Container)WRAPPER, world);
        if (type == Type.BLASTING) {
            if (!smokingRecipe.isPresent()) {
                WRAPPER.m_6836_(0, stack);
                Optional smeltingRecipe = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)WRAPPER, world);
                if (smeltingRecipe.isPresent()) {
                    return InWorldProcessing.applyRecipeOn(stack, (Recipe)smeltingRecipe.get());
                }
                WRAPPER.m_6836_(0, stack);
                Optional blastingRecipe = world.m_7465_().m_44015_(RecipeType.f_44109_, (Container)WRAPPER, world);
                if (blastingRecipe.isPresent()) {
                    return InWorldProcessing.applyRecipeOn(stack, (Recipe)blastingRecipe.get());
                }
            }
            return Collections.emptyList();
        }
        if (type == Type.SMOKING && smokingRecipe.isPresent()) {
            return InWorldProcessing.applyRecipeOn(stack, (Recipe)smokingRecipe.get());
        }
        return null;
    }

    private static int decrementProcessingTime(ItemEntity entity, Type type) {
        CompoundTag processing;
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_("CreateData")) {
            nbt.m_128365_("CreateData", (Tag)new CompoundTag());
        }
        if (!(createData = nbt.m_128469_("CreateData")).m_128441_("Processing")) {
            createData.m_128365_("Processing", (Tag)new CompoundTag());
        }
        if (!(processing = createData.m_128469_("Processing")).m_128441_("Type") || Type.valueOf(processing.m_128461_("Type")) != type) {
            processing.m_128359_("Type", type.name());
            int timeModifierForStackSize = (entity.m_32055_().m_41613_() - 1) / 16 + 1;
            int processingTime = (Integer)AllConfigs.SERVER.kinetics.inWorldProcessingTime.get() * timeModifierForStackSize + 1;
            processing.m_128405_("Time", processingTime);
        }
        int value = processing.m_128451_("Time") - 1;
        processing.m_128405_("Time", value);
        return value;
    }

    public static void applyRecipeOn(ItemEntity entity, Recipe<?> recipe) {
        List<ItemStack> stacks = InWorldProcessing.applyRecipeOn(entity.m_32055_(), recipe);
        if (stacks == null) {
            return;
        }
        if (stacks.isEmpty()) {
            entity.m_146870_();
            return;
        }
        entity.m_32045_(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), additional);
            entityIn.m_20256_(entity.m_20184_());
            entity.f_19853_.m_7967_((Entity)entityIn);
        }
    }

    public static List<ItemStack> applyRecipeOn(ItemStack stackIn, Recipe<?> recipe) {
        ArrayList<ItemStack> stacks;
        if (recipe instanceof ProcessingRecipe) {
            stacks = new ArrayList();
            for (int i = 0; i < stackIn.m_41613_(); ++i) {
                List<ItemStack> rollResults = ((ProcessingRecipe)recipe).rollResults();
                for (ItemStack stack : rollResults) {
                    for (ItemStack previouslyRolled : stacks) {
                        if (stack.m_41619_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)previouslyRolled)) continue;
                        int amount = Math.min(previouslyRolled.m_41741_() - previouslyRolled.m_41613_(), stack.m_41613_());
                        previouslyRolled.m_41769_(amount);
                        stack.m_41774_(amount);
                    }
                    if (stack.m_41619_()) continue;
                    stacks.add(stack);
                }
            }
        } else {
            ItemStack out = recipe.m_8043_().m_41777_();
            stacks = ItemHelper.multipliedOutput(stackIn, out);
        }
        return stacks;
    }

    public static void spawnParticlesForProcessing(@Nullable Level world, Vec3 vec, Type type) {
        if (world == null || !world.f_46443_) {
            return;
        }
        if (world.f_46441_.nextInt(8) != 0) {
            return;
        }
        switch (type) {
            case BLASTING: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, vec.f_82479_, vec.f_82480_ + 0.25, vec.f_82481_, 0.0, 0.0625, 0.0);
                break;
            }
            case SMOKING: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, vec.f_82479_, vec.f_82480_ + 0.25, vec.f_82481_, 0.0, 0.0625, 0.0);
                break;
            }
            case SPLASHING: {
                Vector3f color = new Color(22015).asVectorF();
                world.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), vec.f_82479_ + (double)((world.f_46441_.nextFloat() - 0.5f) * 0.5f), vec.f_82480_ + 0.5, vec.f_82481_ + (double)((world.f_46441_.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123764_, vec.f_82479_ + (double)((world.f_46441_.nextFloat() - 0.5f) * 0.5f), vec.f_82480_ + 0.5, vec.f_82481_ + (double)((world.f_46441_.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
                break;
            }
        }
    }

    public static enum Type {
        SMOKING,
        BLASTING,
        SPLASHING,
        NONE;


        public static Type byBlock(BlockGetter reader, BlockPos pos) {
            BlockState blockState = reader.m_8055_(pos);
            FluidState fluidState = reader.m_6425_(pos);
            if (fluidState.m_76152_() == Fluids.f_76193_ || fluidState.m_76152_() == Fluids.f_76192_) {
                return SPLASHING;
            }
            Block block = blockState.m_60734_();
            if (block == Blocks.f_50083_ || AllBlocks.LIT_BLAZE_BURNER.has(blockState) || BlockTags.f_13087_.m_8110_((Object)block) && blockState.m_61145_((Property)CampfireBlock.f_51227_).orElse(false).booleanValue() || BlazeBurnerBlock.getHeatLevelOf(blockState) == BlazeBurnerBlock.HeatLevel.SMOULDERING) {
                return SMOKING;
            }
            if (block == Blocks.f_49991_ || BlazeBurnerBlock.getHeatLevelOf(blockState).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return BLASTING;
            }
            return NONE;
        }
    }

    public static class SplashingWrapper
    extends RecipeWrapper {
        public SplashingWrapper() {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
        }
    }
}

