/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced.sequencer;

import com.simibubi.create.content.contraptions.relays.advanced.sequencer.Instruction;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencedGearshiftBlock;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencerInstructions;
import com.simibubi.create.content.contraptions.relays.encased.SplitShaftTileEntity;
import java.util.Vector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SequencedGearshiftTileEntity
extends SplitShaftTileEntity {
    Vector<Instruction> instructions = Instruction.createDefault();
    int currentInstruction = -1;
    int currentInstructionDuration = -1;
    float currentInstructionProgress = 0.0f;
    int timer = 0;
    boolean poweredPreviously = false;

    public SequencedGearshiftTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isIdle()) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.currentInstructionDuration < 0) {
            return;
        }
        if (this.timer < this.currentInstructionDuration) {
            ++this.timer;
            this.currentInstructionProgress += this.getInstruction(this.currentInstruction).getTickProgress(this.speed);
            return;
        }
        this.run(this.currentInstruction + 1);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this.isIdle()) {
            return;
        }
        float currentSpeed = Math.abs(this.speed);
        if (Math.abs(previousSpeed) == currentSpeed) {
            return;
        }
        Instruction instruction = this.getInstruction(this.currentInstruction);
        if (instruction == null) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            this.run(-1);
        }
        this.currentInstructionDuration = instruction.getDuration(this.currentInstructionProgress, this.getTheoreticalSpeed());
        this.timer = 0;
    }

    public boolean isIdle() {
        return this.currentInstruction == -1;
    }

    public void onRedstoneUpdate(boolean isPowered, boolean isRunning) {
        if (!this.poweredPreviously && isPowered) {
            this.risingFlank();
        }
        this.poweredPreviously = isPowered;
        if (!this.isIdle()) {
            return;
        }
        if (isPowered == isRunning) {
            return;
        }
        if (!this.f_58857_.m_46753_(this.f_58858_)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(0)), 3);
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.run(0);
    }

    public void risingFlank() {
        Instruction instruction = this.getInstruction(this.currentInstruction);
        if (instruction == null) {
            return;
        }
        if (this.poweredPreviously) {
            return;
        }
        this.poweredPreviously = true;
        switch (instruction.onRedstonePulse()) {
            case CONTINUE: {
                this.run(this.currentInstruction + 1);
                break;
            }
        }
    }

    protected void run(int instructionIndex) {
        Instruction instruction = this.getInstruction(instructionIndex);
        if (instruction == null || instruction.instruction == SequencerInstructions.END) {
            if (this.getModifier() != 0) {
                this.detachKinetics();
            }
            this.currentInstruction = -1;
            this.currentInstructionDuration = -1;
            this.currentInstructionProgress = 0.0f;
            this.timer = 0;
            if (!this.f_58857_.m_46753_(this.f_58858_)) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(0)), 3);
            } else {
                this.sendData();
            }
            return;
        }
        this.detachKinetics();
        this.currentInstructionDuration = instruction.getDuration(0.0f, this.getTheoreticalSpeed());
        this.currentInstruction = instructionIndex;
        this.currentInstructionProgress = 0.0f;
        this.timer = 0;
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)SequencedGearshiftBlock.STATE, (Comparable)Integer.valueOf(instructionIndex + 1)), 3);
    }

    public Instruction getInstruction(int instructionIndex) {
        return instructionIndex >= 0 && instructionIndex < this.instructions.size() ? this.instructions.get(instructionIndex) : null;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("InstructionIndex", this.currentInstruction);
        compound.m_128405_("InstructionDuration", this.currentInstructionDuration);
        compound.m_128350_("InstructionProgress", this.currentInstructionProgress);
        compound.m_128405_("Timer", this.timer);
        compound.m_128379_("PrevPowered", this.poweredPreviously);
        compound.m_128365_("Instructions", (Tag)Instruction.serializeAll(this.instructions));
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        this.currentInstruction = compound.m_128451_("InstructionIndex");
        this.currentInstructionDuration = compound.m_128451_("InstructionDuration");
        this.currentInstructionProgress = compound.m_128457_("InstructionProgress");
        this.poweredPreviously = compound.m_128471_("PrevPowered");
        this.timer = compound.m_128451_("Timer");
        this.instructions = Instruction.deserializeAll(compound.m_128437_("Instructions", 10));
        super.fromTag(compound, clientPacket);
    }

    @Override
    public float getRotationSpeedModifier(Direction face) {
        if (this.isVirtual()) {
            return 1.0f;
        }
        return !this.hasSource() || face == this.getSourceFacing() ? 1.0f : (float)this.getModifier();
    }

    public int getModifier() {
        if (this.currentInstruction >= this.instructions.size()) {
            return 0;
        }
        return this.isIdle() ? 0 : this.instructions.get(this.currentInstruction).getSpeedModifier();
    }
}

