/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltShapes;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlicer;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltMovementHandler;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.curiosities.armor.CopperArmorItem;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.render.DestroyProgressRenderingHandler;
import com.simibubi.create.foundation.block.render.ReducedDestroyEffects;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class BeltBlock
extends HorizontalKineticBlock
implements ITE<BeltTileEntity>,
ISpecialBlockItemRequirement {
    public static final Property<BeltSlope> SLOPE = EnumProperty.m_61587_((String)"slope", BeltSlope.class);
    public static final Property<BeltPart> PART = EnumProperty.m_61587_((String)"part", BeltPart.class);
    public static final BooleanProperty CASING = BooleanProperty.m_61465_((String)"casing");

    public BeltBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(SLOPE, (Comparable)((Object)BeltSlope.HORIZONTAL))).m_61124_(PART, (Comparable)((Object)BeltPart.START))).m_61124_((Property)CASING, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new RenderProperties());
    }

    public void m_49811_(CreativeModeTab p_149666_1_, NonNullList<ItemStack> p_149666_2_) {
        p_149666_2_.add((Object)AllItems.BELT_CONNECTOR.asStack());
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.m_61143_(PART) == newState.m_61143_(PART);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if (face.m_122434_() != this.getRotationAxis(state)) {
            return false;
        }
        return this.getTileEntityOptional((BlockGetter)world, pos).map(BeltTileEntity::hasPulley).orElse(false);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        if (state.m_61143_(SLOPE) == BeltSlope.SIDEWAYS) {
            return Direction.Axis.Y;
        }
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122427_().m_122434_();
    }

    public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return AllItems.BELT_CONNECTOR.asStack();
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        BlockEntity tileEntity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tileEntity instanceof BeltTileEntity && ((BeltTileEntity)tileEntity).hasPulley()) {
            drops.addAll(AllBlocks.SHAFT.getDefaultState().m_60724_(builder));
        }
        return drops;
    }

    public void m_8101_(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack p_220062_4_) {
        BeltTileEntity controllerTE = BeltHelper.getControllerTE((LevelAccessor)worldIn, pos);
        if (controllerTE != null) {
            controllerTE.getInventory().ejectAll();
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        BlockPos entityPosition = entityIn.m_142538_();
        BlockPos beltPos = null;
        if (AllBlocks.BELT.has(worldIn.m_8055_(entityPosition))) {
            beltPos = entityPosition;
        } else if (AllBlocks.BELT.has(worldIn.m_8055_(entityPosition.m_7495_()))) {
            beltPos = entityPosition.m_7495_();
        }
        if (beltPos == null) {
            return;
        }
        if (!(worldIn instanceof Level)) {
            return;
        }
        this.m_7892_(worldIn.m_8055_(beltPos), (Level)worldIn, beltPos, entityIn);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!BeltBlock.canTransportObjects(state)) {
            return;
        }
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (player.m_6144_()) {
                return;
            }
            if (player.m_150110_().f_35935_) {
                return;
            }
        }
        if (((CopperArmorItem)((Object)AllItems.DIVING_BOOTS.get())).isWornBy(entityIn)) {
            return;
        }
        BeltTileEntity belt = BeltHelper.getSegmentTE((LevelAccessor)worldIn, pos);
        if (belt == null) {
            return;
        }
        if (entityIn instanceof ItemEntity && entityIn.m_6084_()) {
            if (worldIn.f_46443_) {
                return;
            }
            if (entityIn.m_20184_().f_82480_ > 0.0) {
                return;
            }
            if (!entityIn.m_6084_()) {
                return;
            }
            if (BeltTunnelInteractionHandler.getTunnelOnPosition(worldIn, pos) != null) {
                return;
            }
            this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
                ItemEntity itemEntity = (ItemEntity)entityIn;
                IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
                if (handler == null) {
                    return;
                }
                ItemStack remainder = handler.insertItem(0, itemEntity.m_32055_().m_41777_(), false);
                if (remainder.m_41619_()) {
                    itemEntity.m_146870_();
                }
            });
            return;
        }
        BeltTileEntity controller = BeltHelper.getControllerTE((LevelAccessor)worldIn, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entityIn)) {
            BeltMovementHandler.TransportedEntityInfo info = controller.passengers.get(entityIn);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entityIn.m_142538_())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entityIn, new BeltMovementHandler.TransportedEntityInfo(pos, state));
            entityIn.m_6853_(true);
        }
    }

    public static boolean canTransportObjects(BlockState state) {
        if (!AllBlocks.BELT.has(state)) {
            return false;
        }
        BeltSlope slope = (BeltSlope)((Object)state.m_61143_(SLOPE));
        return slope != BeltSlope.VERTICAL && slope != BeltSlope.SIDEWAYS;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean isHand;
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(handIn);
        boolean isWrench = AllItems.WRENCH.isIn(heldItem);
        boolean isConnector = AllItems.BELT_CONNECTOR.isIn(heldItem);
        boolean isShaft = AllBlocks.SHAFT.isIn(heldItem);
        boolean isDye = Tags.Items.DYES.m_8110_((Object)heldItem.m_41720_());
        boolean hasWater = EmptyingByBasin.emptyItem(world, heldItem, true).getFirst().getFluid().m_6212_((Fluid)Fluids.f_76193_);
        boolean bl = isHand = heldItem.m_41619_() && handIn == InteractionHand.MAIN_HAND;
        if (isDye || hasWater) {
            if (!world.f_46443_) {
                this.withTileEntityDo((BlockGetter)world, pos, te -> te.applyColor(DyeColor.getColor((ItemStack)heldItem)));
            }
            return InteractionResult.SUCCESS;
        }
        if (isConnector) {
            return BeltSlicer.useConnector(state, world, pos, player, handIn, hit, new BeltSlicer.Feedback());
        }
        if (isWrench) {
            return BeltSlicer.useWrench(state, world, pos, player, handIn, hit, new BeltSlicer.Feedback());
        }
        BeltTileEntity belt = BeltHelper.getSegmentTE((LevelAccessor)world, pos);
        if (belt == null) {
            return InteractionResult.PASS;
        }
        if (isHand) {
            BeltTileEntity controllerBelt = belt.getControllerTE();
            if (controllerBelt == null) {
                return InteractionResult.PASS;
            }
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            MutableBoolean success = new MutableBoolean(false);
            controllerBelt.getInventory().applyToEachWithin((float)belt.index + 0.5f, 0.55f, transportedItemStack -> {
                player.m_150109_().m_150079_(transportedItemStack.stack);
                success.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
            });
            if (success.isTrue()) {
                world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
            }
        }
        if (isShaft) {
            if (state.m_61143_(PART) != BeltPart.MIDDLE) {
                return InteractionResult.PASS;
            }
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)state.m_61124_(PART, (Comparable)((Object)BeltPart.PULLEY)));
            return InteractionResult.SUCCESS;
        }
        if (AllBlocks.BRASS_CASING.isIn(heldItem)) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            AllTriggers.triggerFor(AllTriggers.CASING_BELT, player);
            this.withTileEntityDo((BlockGetter)world, pos, te -> te.setCasingType(BeltTileEntity.CasingType.BRASS));
            return InteractionResult.SUCCESS;
        }
        if (AllBlocks.ANDESITE_CASING.isIn(heldItem)) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            AllTriggers.triggerFor(AllTriggers.CASING_BELT, player);
            this.withTileEntityDo((BlockGetter)world, pos, te -> te.setCasingType(BeltTileEntity.CasingType.ANDESITE));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        if (((Boolean)state.m_61143_((Property)CASING)).booleanValue()) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.withTileEntityDo((BlockGetter)world, pos, te -> te.setCasingType(BeltTileEntity.CasingType.NONE));
            return InteractionResult.SUCCESS;
        }
        if (state.m_61143_(PART) == BeltPart.PULLEY) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)state.m_61124_(PART, (Comparable)((Object)BeltPart.MIDDLE)));
            if (player != null && !player.m_7500_()) {
                player.m_150109_().m_150079_(AllBlocks.SHAFT.asStack());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SLOPE, PART, CASING});
        super.m_7926_(builder);
    }

    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.RAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BeltShapes.getShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_60734_() != this) {
            return Shapes.m_83040_();
        }
        VoxelShape shape = this.m_5940_(state, worldIn, pos, context);
        if (!(context instanceof EntityCollisionContext)) {
            return shape;
        }
        return this.getTileEntityOptional(worldIn, pos).map(te -> {
            if (!((EntityCollisionContext)context).m_166012_().isPresent()) {
                return shape;
            }
            BeltTileEntity controller = te.getControllerTE();
            if (controller == null) {
                return shape;
            }
            if (controller.passengers == null || !controller.passengers.containsKey(((EntityCollisionContext)context).m_166012_().get())) {
                return BeltShapes.getCollisionShape(state);
            }
            return shape;
        }).orElse(shape);
    }

    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)CASING) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public static void initBelt(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return;
        }
        if (world instanceof ServerLevel && ((ServerLevel)world).m_7726_().m_8481_() instanceof DebugLevelSource) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (!AllBlocks.BELT.has(state)) {
            return;
        }
        int limit = 1000;
        BlockPos currentPos = pos;
        while (limit-- > 0) {
            BlockState currentState = world.m_8055_(currentPos);
            if (!AllBlocks.BELT.has(currentState)) {
                world.m_46961_(pos, true);
                return;
            }
            BlockPos nextSegmentPosition = BeltBlock.nextSegmentPosition(currentState, currentPos, false);
            if (nextSegmentPosition == null) break;
            if (!world.isAreaLoaded(nextSegmentPosition, 0)) {
                return;
            }
            currentPos = nextSegmentPosition;
        }
        int index = 0;
        List<BlockPos> beltChain = BeltBlock.getBeltChain(world, currentPos);
        if (beltChain.size() < 2) {
            world.m_46961_(currentPos, true);
            return;
        }
        for (BlockPos beltPos : beltChain) {
            BlockEntity tileEntity = world.m_7702_(beltPos);
            BlockState currentState = world.m_8055_(beltPos);
            if (tileEntity instanceof BeltTileEntity && AllBlocks.BELT.has(currentState)) {
                BeltTileEntity te = (BeltTileEntity)tileEntity;
                te.setController(currentPos);
                te.beltLength = beltChain.size();
                te.index = index;
                te.attachKinetics();
                te.m_6596_();
                te.sendData();
                if (te.isController() && !BeltBlock.canTransportObjects(currentState)) {
                    te.getInventory().ejectAll();
                }
            } else {
                world.m_46961_(currentPos, true);
                return;
            }
            ++index;
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        if (isMoving) {
            return;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof BeltTileEntity) {
            BeltTileEntity beltTileEntity = (BeltTileEntity)te;
            if (beltTileEntity.isController()) {
                beltTileEntity.getInventory().ejectAll();
            }
            world.m_46747_(pos);
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockPos currentPos = BeltBlock.nextSegmentPosition(state, pos, forward);
            if (currentPos == null) continue;
            world.m_6801_(currentPos.hashCode(), currentPos, -1);
            BlockState currentState = world.m_8055_(currentPos);
            if (!AllBlocks.BELT.has(currentState)) continue;
            boolean hasPulley = false;
            BlockEntity tileEntity = world.m_7702_(currentPos);
            if (tileEntity instanceof BeltTileEntity) {
                BeltTileEntity belt = (BeltTileEntity)tileEntity;
                if (belt.isController()) {
                    belt.getInventory().ejectAll();
                }
                belt.m_7651_();
                hasPulley = belt.hasPulley();
            }
            BlockState shaftState = (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)this.getRotationAxis(currentState));
            world.m_7731_(currentPos, hasPulley ? shaftState : Blocks.f_50016_.m_49966_(), 3);
            world.m_46796_(2001, currentPos, Block.m_49956_((BlockState)currentState));
        }
    }

    public BlockState m_7417_(BlockState state, Direction side, BlockState p_196271_3_, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        if (side.m_122434_().m_122479_()) {
            this.updateTunnelConnections(world, pos.m_7494_());
        }
        return state;
    }

    private void updateTunnelConnections(LevelAccessor world, BlockPos pos) {
        Block tunnelBlock = world.m_8055_(pos).m_60734_();
        if (tunnelBlock instanceof BeltTunnelBlock) {
            ((BeltTunnelBlock)tunnelBlock).updateTunnel(world, pos);
        }
    }

    public static List<BlockPos> getBeltChain(Level world, BlockPos controllerPos) {
        BlockState state;
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        BlockState blockState = world.m_8055_(controllerPos);
        if (!AllBlocks.BELT.has(blockState)) {
            return positions;
        }
        int limit = 1000;
        BlockPos current = controllerPos;
        while (limit-- > 0 && current != null && AllBlocks.BELT.has(state = world.m_8055_(current))) {
            positions.add(current);
            current = BeltBlock.nextSegmentPosition(state, current, true);
        }
        return positions;
    }

    public static BlockPos nextSegmentPosition(BlockState state, BlockPos pos, boolean forward) {
        int offset;
        Direction direction = (Direction)state.m_61143_(HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)state.m_61143_(SLOPE));
        BeltPart part = (BeltPart)((Object)state.m_61143_(PART));
        int n = offset = forward ? 1 : -1;
        if (part == BeltPart.END && forward || part == BeltPart.START && !forward) {
            return null;
        }
        if (slope == BeltSlope.VERTICAL) {
            return pos.m_6630_(direction.m_122421_() == Direction.AxisDirection.POSITIVE ? offset : -offset);
        }
        pos = pos.m_5484_(direction, offset);
        if (slope != BeltSlope.HORIZONTAL && slope != BeltSlope.SIDEWAYS) {
            return pos.m_6630_(slope == BeltSlope.UPWARD ? offset : -offset);
        }
        return pos;
    }

    public static boolean canAccessFromSide(Direction facing, BlockState belt) {
        return true;
    }

    @Override
    public Class<BeltTileEntity> getTileEntityClass() {
        return BeltTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends BeltTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.BELT.get();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity te) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        if (state.m_61143_(PART) != BeltPart.MIDDLE) {
            required.add(AllBlocks.SHAFT.asStack());
        }
        if (state.m_61143_(PART) == BeltPart.START) {
            required.add(AllItems.BELT_CONNECTOR.asStack());
        }
        if (required.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, required);
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        BlockState rotate = super.m_6843_(state, rot);
        if (state.m_61143_(SLOPE) != BeltSlope.VERTICAL) {
            return rotate;
        }
        if (((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122421_() != ((Direction)rotate.m_61143_(HORIZONTAL_FACING)).m_122421_()) {
            if (state.m_61143_(PART) == BeltPart.START) {
                return (BlockState)rotate.m_61124_(PART, (Comparable)((Object)BeltPart.END));
            }
            if (state.m_61143_(PART) == BeltPart.END) {
                return (BlockState)rotate.m_61124_(PART, (Comparable)((Object)BeltPart.START));
            }
        }
        return rotate;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static class RenderProperties
    extends ReducedDestroyEffects
    implements DestroyProgressRenderingHandler {
        @Override
        public boolean renderDestroyProgress(ClientLevel level, LevelRenderer renderer, int breakerId, BlockPos pos, int progress, BlockState blockState) {
            BlockEntity blockEntity = level.m_7702_(pos);
            BlockEntity blockEntity2 = blockEntity;
            if (blockEntity2 instanceof BeltTileEntity) {
                BeltTileEntity belt = (BeltTileEntity)blockEntity2;
                for (BlockPos beltPos : BeltBlock.getBeltChain((Level)level, belt.getController())) {
                    renderer.m_109774_(beltPos.hashCode(), beltPos, progress);
                }
            }
            return false;
        }
    }
}

