/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.ShadowRenderHelper;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BeltRenderer
extends SafeTileEntityRenderer<BeltTileEntity> {
    public BeltRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(BeltTileEntity te) {
        return te.isController();
    }

    @Override
    protected void renderSafe(BeltTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!Backend.getInstance().canUseInstancing(te.m_58904_())) {
            BlockState blockState = te.m_58900_();
            if (!AllBlocks.BELT.has(blockState)) {
                return;
            }
            BeltSlope beltSlope = (BeltSlope)((Object)blockState.m_61143_(BeltBlock.SLOPE));
            BeltPart part = (BeltPart)((Object)blockState.m_61143_(BeltBlock.PART));
            Direction facing = (Direction)blockState.m_61143_(BeltBlock.HORIZONTAL_FACING);
            Direction.AxisDirection axisDirection = facing.m_122421_();
            boolean downward = beltSlope == BeltSlope.DOWNWARD;
            boolean upward = beltSlope == BeltSlope.UPWARD;
            boolean diagonal = downward || upward;
            boolean start = part == BeltPart.START;
            boolean end = part == BeltPart.END;
            boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
            boolean alongX = facing.m_122434_() == Direction.Axis.X;
            PoseStack localTransforms = new PoseStack();
            TransformStack msr = TransformStack.cast((PoseStack)localTransforms);
            VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
            float renderTick = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateY((double)(AngleHelper.horizontalAngle(facing) + (float)(upward ? 180 : 0) + (float)(sideways ? 270 : 0)))).rotateZ(sideways ? 90.0 : 0.0)).rotateX(!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90.0 : 0.0)).unCentre();
            if (downward || beltSlope == BeltSlope.VERTICAL && axisDirection == Direction.AxisDirection.POSITIVE) {
                boolean b = start;
                start = end;
                end = b;
            }
            DyeColor color = te.color.orElse(null);
            for (boolean bottom : Iterate.trueAndFalse) {
                PartialModel beltPartial = BeltRenderer.getBeltPartial(diagonal, start, end, bottom);
                SuperByteBuffer beltBuffer = CachedBufferer.partial(beltPartial, blockState).light(light);
                SpriteShiftEntry spriteShift = BeltRenderer.getSpriteShiftEntry(color, diagonal, bottom);
                float speed = te.getSpeed();
                if (speed != 0.0f || te.color.isPresent()) {
                    float time = renderTick * (float)axisDirection.m_122540_();
                    if (diagonal && downward ^ alongX || !sideways && !diagonal && alongX || sideways && axisDirection == Direction.AxisDirection.NEGATIVE) {
                        speed = -speed;
                    }
                    float scrollMult = diagonal ? 0.375f : 0.5f;
                    float spriteSize = spriteShift.getTarget().m_118412_() - spriteShift.getTarget().m_118411_();
                    double scroll = (double)(speed * time) / 504.0 + (bottom ? 0.5 : 0.0);
                    scroll -= Math.floor(scroll);
                    scroll = scroll * (double)spriteSize * (double)scrollMult;
                    beltBuffer.shiftUVScrolling(spriteShift, (float)scroll);
                }
                beltBuffer.transform(localTransforms).renderInto(ms, vb);
                if (diagonal) break;
            }
            if (te.hasPulley()) {
                Direction dir = sideways ? Direction.UP : ((Direction)blockState.m_61143_(BeltBlock.HORIZONTAL_FACING)).m_122427_();
                Supplier<PoseStack> matrixStackSupplier = () -> {
                    PoseStack stack = new PoseStack();
                    TransformStack stacker = TransformStack.cast((PoseStack)stack);
                    stacker.centre();
                    if (dir.m_122434_() == Direction.Axis.X) {
                        stacker.rotateY(90.0);
                    }
                    if (dir.m_122434_() == Direction.Axis.Y) {
                        stacker.rotateX(90.0);
                    }
                    stacker.rotateX(90.0);
                    stacker.unCentre();
                    return stack;
                };
                SuperByteBuffer superBuffer = CachedBufferer.partialDirectional(AllBlockPartials.BELT_PULLEY, blockState, dir, matrixStackSupplier);
                KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, light).renderInto(ms, vb);
            }
        }
        this.renderItems(te, partialTicks, ms, buffer, light, overlay);
    }

    public static SpriteShiftEntry getSpriteShiftEntry(DyeColor color, boolean diagonal, boolean bottom) {
        if (color != null) {
            return (diagonal ? AllSpriteShifts.DYED_DIAGONAL_BELTS : (bottom ? AllSpriteShifts.DYED_OFFSET_BELTS : AllSpriteShifts.DYED_BELTS)).get(color);
        }
        return diagonal ? AllSpriteShifts.BELT_DIAGONAL : (bottom ? AllSpriteShifts.BELT_OFFSET : AllSpriteShifts.BELT);
    }

    public static PartialModel getBeltPartial(boolean diagonal, boolean start, boolean end, boolean bottom) {
        if (diagonal) {
            if (start) {
                return AllBlockPartials.BELT_DIAGONAL_START;
            }
            if (end) {
                return AllBlockPartials.BELT_DIAGONAL_END;
            }
            return AllBlockPartials.BELT_DIAGONAL_MIDDLE;
        }
        if (bottom) {
            if (start) {
                return AllBlockPartials.BELT_START_BOTTOM;
            }
            if (end) {
                return AllBlockPartials.BELT_END_BOTTOM;
            }
            return AllBlockPartials.BELT_MIDDLE_BOTTOM;
        }
        if (start) {
            return AllBlockPartials.BELT_START;
        }
        if (end) {
            return AllBlockPartials.BELT_END;
        }
        return AllBlockPartials.BELT_MIDDLE;
    }

    protected void renderItems(BeltTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!te.isController()) {
            return;
        }
        if (te.beltLength == 0) {
            return;
        }
        ms.m_85836_();
        Direction beltFacing = te.getBeltFacing();
        Vec3i directionVec = beltFacing.m_122436_();
        Vec3 beltStartOffset = Vec3.m_82528_((Vec3i)directionVec).m_82490_(-0.5).m_82520_(0.5, 0.9375, 0.5);
        ms.m_85837_(beltStartOffset.f_82479_, beltStartOffset.f_82480_, beltStartOffset.f_82481_);
        BeltSlope slope = (BeltSlope)((Object)te.m_58900_().m_61143_(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        boolean slopeAlongX = beltFacing.m_122434_() == Direction.Axis.X;
        boolean onContraption = te.m_58904_() instanceof WrappedWorld;
        for (TransportedItemStack transported : te.getInventory().getTransportedItems()) {
            boolean alongX;
            boolean tiltForward;
            float sideOffset;
            float offset;
            ms.m_85836_();
            TransformStack.cast((PoseStack)ms).nudge(transported.angle);
            if (te.getSpeed() == 0.0f) {
                offset = transported.beltPosition;
                sideOffset = transported.sideOffset;
            } else {
                offset = Mth.m_14179_((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
                sideOffset = Mth.m_14179_((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
            }
            float verticalMovement = (double)offset < 0.5 ? 0.0f : (float)verticality * (Math.min(offset, (float)te.beltLength - 0.5f) - 0.5f);
            Vec3 offsetVec = Vec3.m_82528_((Vec3i)directionVec).m_82490_((double)offset);
            if (verticalMovement != 0.0f) {
                offsetVec = offsetVec.m_82520_(0.0, (double)verticalMovement, 0.0);
            }
            boolean onSlope = slope != BeltSlope.HORIZONTAL && Mth.m_14036_((float)offset, (float)0.5f, (float)((float)te.beltLength - 0.5f)) == offset;
            boolean bl = tiltForward = (slope == BeltSlope.DOWNWARD ^ beltFacing.m_122421_() == Direction.AxisDirection.POSITIVE) == (beltFacing.m_122434_() == Direction.Axis.Z);
            float slopeAngle = onSlope ? (tiltForward ? -45.0f : 45.0f) : 0.0f;
            ms.m_85837_(offsetVec.f_82479_, offsetVec.f_82480_, offsetVec.f_82481_);
            boolean bl2 = alongX = beltFacing.m_122427_().m_122434_() == Direction.Axis.X;
            if (!alongX) {
                sideOffset *= -1.0f;
            }
            ms.m_85837_(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
            int stackLight = onContraption ? light : this.getPackedLight(te, offset);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            boolean renderUpright = BeltHelper.isItemUpright(transported.stack);
            boolean blockItem = itemRenderer.m_174264_(transported.stack, te.m_58904_(), null, 0).m_7539_();
            int count = Mth.m_14173_((int)transported.stack.m_41613_()) / 2;
            Random r = new Random(transported.angle);
            boolean slopeShadowOnly = renderUpright && onSlope;
            float slopeOffset = 0.125f;
            if (slopeShadowOnly) {
                ms.m_85836_();
            }
            if (!renderUpright || slopeShadowOnly) {
                ms.m_85845_(new Vector3f(slopeAlongX ? 0.0f : 1.0f, 0.0f, slopeAlongX ? 1.0f : 0.0f).m_122240_(slopeAngle));
            }
            if (onSlope) {
                ms.m_85837_(0.0, (double)slopeOffset, 0.0);
            }
            ms.m_85836_();
            ms.m_85837_(0.0, (double)-0.12f, 0.0);
            ShadowRenderHelper.renderShadow(ms, buffer, 0.75f, 0.2f);
            ms.m_85849_();
            if (slopeShadowOnly) {
                ms.m_85849_();
                ms.m_85837_(0.0, (double)slopeOffset, 0.0);
            }
            if (renderUpright) {
                Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
                if (renderViewEntity != null) {
                    Vec3 positionVec = renderViewEntity.m_20182_();
                    Vec3 vectorForOffset = BeltHelper.getVectorForOffset(te, offset);
                    Vec3 diff = vectorForOffset.m_82546_(positionVec);
                    float yRot = (float)(Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_) + Math.PI);
                    ms.m_85845_(Vector3f.f_122225_.m_122270_(yRot));
                }
                ms.m_85837_(0.0, 0.09375, 0.0625);
            }
            for (int i = 0; i <= count; ++i) {
                ms.m_85836_();
                ms.m_85845_(Vector3f.f_122225_.m_122240_((float)transported.angle));
                if (!blockItem && !renderUpright) {
                    ms.m_85837_(0.0, -0.09375, 0.0);
                    ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                }
                if (blockItem) {
                    ms.m_85837_((double)(r.nextFloat() * 0.0625f * (float)i), 0.0, (double)(r.nextFloat() * 0.0625f * (float)i));
                }
                ms.m_85841_(0.5f, 0.5f, 0.5f);
                itemRenderer.m_174242_(null, transported.stack, ItemTransforms.TransformType.FIXED, false, ms, buffer, te.m_58904_(), stackLight, overlay, 0);
                ms.m_85849_();
                if (!renderUpright) {
                    if (!blockItem) {
                        ms.m_85845_(Vector3f.f_122225_.m_122240_(10.0f));
                    }
                    ms.m_85837_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                    continue;
                }
                ms.m_85837_(0.0, 0.0, -0.0625);
            }
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    protected int getPackedLight(BeltTileEntity controller, float beltPos) {
        int segment = (int)Math.floor(beltPos) * 2;
        if (controller.light == null || segment >= controller.light.length || segment < 0) {
            return 0;
        }
        return LightTexture.m_109885_((int)controller.light[segment], (int)controller.light[segment + 1]);
    }
}

