/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.jozufozu.flywheel.util.VirtualEmptyModelData;
import com.simibubi.create.content.contraptions.relays.elementary.BracketedTileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class BracketedKineticBlockModel
extends BakedModelWrapper<BakedModel> {
    private static final ModelProperty<BracketedModelData> BRACKET_PROPERTY = new ModelProperty();

    public BracketedKineticBlockModel(BakedModel template) {
        super(template);
    }

    public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData tileData) {
        if (tileData == VirtualEmptyModelData.INSTANCE) {
            return tileData;
        }
        BracketedModelData data = new BracketedModelData();
        BracketedTileEntityBehaviour attachmentBehaviour = TileEntityBehaviour.get((BlockGetter)world, pos, BracketedTileEntityBehaviour.TYPE);
        if (attachmentBehaviour != null) {
            data.putBracket(attachmentBehaviour.getBracket());
        }
        return new ModelDataMap.Builder().withInitial(BRACKET_PROPERTY, (Object)data).build();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData data) {
        if (data instanceof ModelDataMap) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            ModelDataMap modelDataMap = (ModelDataMap)data;
            if (modelDataMap.hasProperty(BRACKET_PROPERTY)) {
                quads = new ArrayList<BakedQuad>(quads);
                this.addQuads(quads, state, side, rand, (IModelData)modelDataMap, (BracketedModelData)modelDataMap.getData(BRACKET_PROPERTY));
            }
            return quads;
        }
        return super.getQuads(state, side, rand, data);
    }

    private void addQuads(List<BakedQuad> quads, BlockState state, Direction side, Random rand, IModelData data, BracketedModelData pipeData) {
        BakedModel bracket = pipeData.getBracket();
        if (bracket == null) {
            return;
        }
        quads.addAll(bracket.getQuads(state, side, rand, data));
    }

    private class BracketedModelData {
        BakedModel bracket;

        private BracketedModelData() {
        }

        public void putBracket(BlockState state) {
            this.bracket = Minecraft.m_91087_().m_91289_().m_110910_(state);
        }

        public BakedModel getBracket() {
            return this.bracket;
        }
    }
}

