/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.encased;

import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.material.Material;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.contraptions.relays.encased.SplitShaftTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;

public class SplitShaftInstance
extends KineticTileInstance<SplitShaftTileEntity> {
    protected final ArrayList<RotatingData> keys = new ArrayList(2);

    public SplitShaftInstance(MaterialManager modelManager, SplitShaftTileEntity tile) {
        super(modelManager, tile);
        float speed = tile.getSpeed();
        Material<RotatingData> rotatingMaterial = this.getRotatingMaterial();
        for (Direction dir : Iterate.directionsInAxis(this.getRotationAxis())) {
            Instancer half = rotatingMaterial.getModel(AllBlockPartials.SHAFT_HALF, this.blockState, dir);
            float splitSpeed = speed * tile.getRotationSpeedModifier(dir);
            this.keys.add(this.setup((RotatingData)half.createInstance(), splitSpeed));
        }
    }

    public void update() {
        Block block = this.blockState.m_60734_();
        Direction.Axis boxAxis = ((IRotate)block).getRotationAxis(this.blockState);
        Direction[] directions = Iterate.directionsInAxis(boxAxis);
        for (int i : Iterate.zeroAndOne) {
            this.updateRotation(this.keys.get(i), ((SplitShaftTileEntity)this.tile).getSpeed() * ((SplitShaftTileEntity)this.tile).getRotationSpeedModifier(directions[i]));
        }
    }

    public void updateLight() {
        this.relight(this.pos, this.keys.stream());
    }

    public void remove() {
        this.keys.forEach(InstanceData::delete);
        this.keys.clear();
    }
}

