/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gearbox;

import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.material.Material;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.flwdata.RotatingData;
import com.simibubi.create.content.contraptions.relays.gearbox.GearboxTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GearboxInstance
extends KineticTileInstance<GearboxTileEntity> {
    protected final EnumMap<Direction, RotatingData> keys = new EnumMap(Direction.class);
    protected Direction sourceFacing;

    public GearboxInstance(MaterialManager modelManager, GearboxTileEntity tile) {
        super(modelManager, tile);
        Direction.Axis boxAxis = (Direction.Axis)this.blockState.m_61143_((Property)BlockStateProperties.f_61365_);
        int blockLight = this.world.m_45517_(LightLayer.BLOCK, this.pos);
        int skyLight = this.world.m_45517_(LightLayer.SKY, this.pos);
        this.updateSourceFacing();
        Material<RotatingData> rotatingMaterial = this.getRotatingMaterial();
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.m_122434_();
            if (boxAxis == axis) continue;
            Instancer shaft = rotatingMaterial.getModel(AllBlockPartials.SHAFT_HALF, this.blockState, direction);
            RotatingData key = (RotatingData)shaft.createInstance();
            key.setRotationAxis(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122432_()).setRotationalSpeed(this.getSpeed(direction)).setRotationOffset(this.getRotationOffset(axis)).setColor(tile).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
            this.keys.put(direction, key);
        }
    }

    private float getSpeed(Direction direction) {
        float speed = ((GearboxTileEntity)this.tile).getSpeed();
        if (speed != 0.0f && this.sourceFacing != null) {
            if (this.sourceFacing.m_122434_() == direction.m_122434_()) {
                speed *= this.sourceFacing == direction ? 1.0f : -1.0f;
            } else if (this.sourceFacing.m_122421_() == direction.m_122421_()) {
                speed *= -1.0f;
            }
        }
        return speed;
    }

    protected void updateSourceFacing() {
        if (((GearboxTileEntity)this.tile).hasSource()) {
            BlockPos source = ((GearboxTileEntity)this.tile).source.m_141950_((Vec3i)this.pos);
            this.sourceFacing = Direction.m_122372_((float)source.m_123341_(), (float)source.m_123342_(), (float)source.m_123343_());
        } else {
            this.sourceFacing = null;
        }
    }

    public void update() {
        this.updateSourceFacing();
        for (Map.Entry<Direction, RotatingData> key : this.keys.entrySet()) {
            Direction direction = key.getKey();
            Direction.Axis axis = direction.m_122434_();
            this.updateRotation(key.getValue(), axis, this.getSpeed(direction));
        }
    }

    public void updateLight() {
        this.relight(this.pos, this.keys.values().stream());
    }

    public void remove() {
        this.keys.values().forEach(InstanceData::delete);
        this.keys.clear();
    }
}

