/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.simibubi.create.content.curiosities.bell.SoulBaseParticle;
import com.simibubi.create.content.curiosities.bell.SoulParticle;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SoulPulseEffect {
    public static final int MAX_DISTANCE = 11;
    private static final List<List<BlockPos>> LAYERS = SoulPulseEffect.genLayers();
    private static final int WAITING_TICKS = 100;
    public static final int TICKS_PER_LAYER = 6;
    private int ticks;
    public final BlockPos pos;
    public final int distance;
    public final List<BlockPos> added;

    public SoulPulseEffect(BlockPos pos, int distance, boolean canOverlap) {
        this.ticks = 6 * distance;
        this.pos = pos;
        this.distance = distance;
        this.added = canOverlap ? null : new ArrayList();
    }

    public boolean finished() {
        return this.ticks <= -100;
    }

    public boolean canOverlap() {
        return this.added == null;
    }

    public List<BlockPos> tick(Level world) {
        if (this.finished()) {
            return null;
        }
        --this.ticks;
        if (this.ticks < 0 || this.ticks % 6 != 0) {
            return null;
        }
        List<BlockPos> spawns = this.getPotentialSoulSpawns(world);
        while (spawns.isEmpty() && this.ticks > 0) {
            this.ticks -= 6;
            spawns.addAll(this.getPotentialSoulSpawns(world));
        }
        return spawns;
    }

    public int currentLayerIdx() {
        return this.distance - this.ticks / 6 - 1;
    }

    public List<BlockPos> getPotentialSoulSpawns(Level world) {
        if (world == null) {
            return new ArrayList<BlockPos>();
        }
        return SoulPulseEffect.getLayer(this.currentLayerIdx()).map(p -> p.m_141952_((Vec3i)this.pos)).filter(p -> SoulPulseEffect.canSpawnSoulAt(world, p, true)).collect(Collectors.toList());
    }

    public static boolean isDark(Level world, BlockPos at) {
        return world.m_45517_(LightLayer.BLOCK, at) < 8;
    }

    public static boolean canSpawnSoulAt(Level world, BlockPos at, boolean ignoreLight) {
        EntityType dummy = EntityType.f_20501_;
        double dummyWidth = 0.2;
        double dummyHeight = 0.75;
        double w2 = dummyWidth / 2.0;
        return world != null && NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)world, (BlockPos)at, (EntityType)dummy) && (ignoreLight || SoulPulseEffect.isDark(world, at)) && world.m_45764_(null, new AABB((double)at.m_123341_() + 0.5 - w2, (double)at.m_123342_(), (double)at.m_123343_() + 0.5 - w2, (double)at.m_123341_() + 0.5 + w2, (double)at.m_123342_() + dummyHeight, (double)at.m_123343_() + 0.5 + w2), (a, b) -> true).allMatch(VoxelShape::m_83281_);
    }

    public void spawnParticles(Level world, BlockPos at) {
        if (world == null || !world.f_46443_) {
            return;
        }
        Vec3 p = Vec3.m_82528_((Vec3i)at);
        if (this.canOverlap()) {
            world.m_7107_((ParticleOptions)((int)Math.round(VecHelper.getCenterOf((Vec3i)this.pos).m_82554_(VecHelper.getCenterOf((Vec3i)at))) >= this.distance ? new SoulParticle.PerimeterData() : new SoulParticle.ExpandingPerimeterData()), p.f_82479_ + 0.5, p.f_82480_ + 0.5, p.f_82481_ + 0.5, 0.0, 0.0, 0.0);
        }
        if (world.m_45517_(LightLayer.BLOCK, at) < 8) {
            world.m_7107_((ParticleOptions)new SoulParticle.Data(), p.f_82479_ + 0.5, p.f_82480_ + 0.5, p.f_82481_ + 0.5, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)new SoulBaseParticle.Data(), p.f_82479_ + 0.5, p.f_82480_ + 0.01, p.f_82481_ + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private static List<List<BlockPos>> genLayers() {
        ArrayList<List<BlockPos>> layers = new ArrayList<List<BlockPos>>();
        for (int i = 0; i < 11; ++i) {
            layers.add(new ArrayList());
        }
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 11; ++y) {
                for (int z = 0; z < 11; ++z) {
                    BlockPos prev;
                    int i;
                    BlockPos candidate = new BlockPos(x, y, z);
                    int dist = (int)Math.round(Math.sqrt(candidate.m_123299_(0.0, 0.0, 0.0, false)));
                    if (dist > 11) continue;
                    if (dist <= 0) {
                        dist = 1;
                    }
                    List layer = (List)layers.get(dist - 1);
                    int start = layer.size();
                    int end = start + 1;
                    layer.add(candidate);
                    if (candidate.m_123341_() != 0) {
                        layer.add(new BlockPos(-candidate.m_123341_(), candidate.m_123342_(), candidate.m_123343_()));
                        ++end;
                    }
                    if (candidate.m_123342_() != 0) {
                        for (i = start; i < end; ++i) {
                            prev = (BlockPos)layer.get(i);
                            layer.add(new BlockPos(prev.m_123341_(), -prev.m_123342_(), prev.m_123343_()));
                        }
                        end += end - start;
                    }
                    if (candidate.m_123343_() == 0) continue;
                    for (i = start; i < end; ++i) {
                        prev = (BlockPos)layer.get(i);
                        layer.add(new BlockPos(prev.m_123341_(), prev.m_123342_(), -prev.m_123343_()));
                    }
                }
            }
        }
        return layers;
    }

    public static Stream<BlockPos> getLayer(int idx) {
        if (idx < 0 || idx >= 11) {
            return Stream.empty();
        }
        return LAYERS.get(idx).stream();
    }
}

