/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.curiosities.symmetry.SymmetryEffectPacket;
import com.simibubi.create.content.curiosities.symmetry.SymmetryWandScreen;
import com.simibubi.create.content.curiosities.symmetry.client.SymmetryWandItemRenderer;
import com.simibubi.create.content.curiosities.symmetry.mirror.CrossPlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.PlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class SymmetryWandItem
extends Item {
    public static final String SYMMETRY = "symmetry";
    private static final String ENABLE = "enable";

    public SymmetryWandItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        player.m_36335_().m_41524_((Item)this, 5);
        ItemStack wand = player.m_21120_(context.m_43724_());
        SymmetryWandItem.checkNBT(wand);
        if (player.m_6144_()) {
            if (player.f_19853_.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.openWandGUI(wand, context.m_43724_()));
                player.m_36335_().m_41524_((Item)this, 5);
            }
            return InteractionResult.SUCCESS;
        }
        if (context.m_43725_().f_46443_ || context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        CompoundTag compound = wand.m_41783_().m_128469_(SYMMETRY);
        pos = pos.m_142300_(context.m_43719_());
        SymmetryMirror previousElement = SymmetryMirror.fromNBT(compound);
        wand.m_41783_().m_128379_(ENABLE, true);
        Vec3 pos3d = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        SymmetryMirror newElement = new PlaneMirror(pos3d);
        if (previousElement instanceof EmptyMirror) {
            newElement.setOrientation(player.m_6350_() == Direction.NORTH || player.m_6350_() == Direction.SOUTH ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            newElement.enable = true;
            wand.m_41783_().m_128379_(ENABLE, true);
        } else {
            previousElement.setPosition(pos3d);
            if (previousElement instanceof PlaneMirror) {
                previousElement.setOrientation(player.m_6350_() == Direction.NORTH || player.m_6350_() == Direction.SOUTH ? PlaneMirror.Align.XY.ordinal() : PlaneMirror.Align.YZ.ordinal());
            }
            if (previousElement instanceof CrossPlaneMirror) {
                float rotation = player.m_6080_();
                float abs = Math.abs(rotation % 90.0f);
                boolean diagonal = abs > 22.0f && abs < 67.0f;
                previousElement.setOrientation(diagonal ? CrossPlaneMirror.Align.D.ordinal() : CrossPlaneMirror.Align.Y.ordinal());
            }
            newElement = previousElement;
        }
        compound = newElement.writeToNbt();
        wand.m_41783_().m_128365_(SYMMETRY, (Tag)compound);
        player.m_21008_(context.m_43724_(), wand);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack wand = playerIn.m_21120_(handIn);
        SymmetryWandItem.checkNBT(wand);
        if (playerIn.m_6144_()) {
            if (worldIn.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.openWandGUI(playerIn.m_21120_(handIn), handIn));
                playerIn.m_36335_().m_41524_((Item)this, 5);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)wand);
        }
        wand.m_41783_().m_128379_(ENABLE, false);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)wand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openWandGUI(ItemStack wand, InteractionHand hand) {
        ScreenOpener.open(new SymmetryWandScreen(wand, hand));
    }

    private static void checkNBT(ItemStack wand) {
        if (!wand.m_41782_() || !wand.m_41783_().m_128441_(SYMMETRY)) {
            wand.m_41751_(new CompoundTag());
            wand.m_41783_().m_128365_(SYMMETRY, (Tag)new EmptyMirror(new Vec3(0.0, 0.0, 0.0)).writeToNbt());
            wand.m_41783_().m_128379_(ENABLE, false);
        }
    }

    public static boolean isEnabled(ItemStack stack) {
        SymmetryWandItem.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128471_(ENABLE) && !tag.m_128471_("Simulate");
    }

    public static SymmetryMirror getMirror(ItemStack stack) {
        SymmetryWandItem.checkNBT(stack);
        return SymmetryMirror.fromNBT(stack.m_41783_().m_128469_(SYMMETRY));
    }

    public static void configureSettings(ItemStack stack, SymmetryMirror mirror) {
        SymmetryWandItem.checkNBT(stack);
        stack.m_41783_().m_128365_(SYMMETRY, (Tag)mirror.writeToNbt());
    }

    public static void apply(Level world, ItemStack wand, Player player, BlockPos pos, BlockState block) {
        SymmetryWandItem.checkNBT(wand);
        if (!SymmetryWandItem.isEnabled(wand)) {
            return;
        }
        if (!BlockItem.f_41373_.containsKey(block.m_60734_())) {
            return;
        }
        HashMap<BlockPos, BlockState> blockSet = new HashMap<BlockPos, BlockState>();
        blockSet.put(pos, block);
        SymmetryMirror symmetry = SymmetryMirror.fromNBT(wand.m_41783_().m_128469_(SYMMETRY));
        Vec3 mirrorPos = symmetry.getPosition();
        if (mirrorPos.m_82554_(Vec3.m_82528_((Vec3i)pos)) > (double)((Integer)AllConfigs.SERVER.curiosities.maxSymmetryWandRange.get()).intValue()) {
            return;
        }
        if (!player.m_7500_() && SymmetryWandItem.isHoldingBlock(player, block) && BlockHelper.findAndRemoveInInventory(block, player, 1) == 0) {
            return;
        }
        symmetry.process(blockSet);
        BlockPos to = new BlockPos(mirrorPos);
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        targets.add(pos);
        for (BlockPos position : blockSet.keySet()) {
            if (position.equals((Object)pos) || !world.m_45752_(block, position, CollisionContext.m_82750_((Entity)player))) continue;
            BlockState blockState = (BlockState)blockSet.get(position);
            for (Direction face : Iterate.directions) {
                blockState = blockState.m_60728_(face, world.m_8055_(position.m_142300_(face)), (LevelAccessor)world, position, position.m_142300_(face));
            }
            if (player.m_7500_()) {
                world.m_46597_(position, blockState);
                targets.add(position);
                continue;
            }
            BlockState toReplace = world.m_8055_(position);
            if (!toReplace.m_60767_().m_76336_() || toReplace.m_60800_((BlockGetter)world, position) == -1.0f) continue;
            if (AllBlocks.CART_ASSEMBLER.has(blockState)) {
                BlockState railBlock = CartAssemblerBlock.getRailBlock(blockState);
                if (BlockHelper.findAndRemoveInInventory(railBlock, player, 1) == 0) continue;
                if (BlockHelper.findAndRemoveInInventory(blockState, player, 1) == 0) {
                    blockState = railBlock;
                }
            } else if (BlockHelper.findAndRemoveInInventory(blockState, player, 1) == 0) continue;
            BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)position);
            FluidState ifluidstate = world.m_6425_(position);
            world.m_7731_(position, ifluidstate.m_76188_(), 16);
            world.m_46597_(position, blockState);
            CompoundTag wandNbt = wand.m_41784_();
            wandNbt.m_128379_("Simulate", true);
            boolean placeInterrupted = ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP);
            wandNbt.m_128379_("Simulate", false);
            if (placeInterrupted) {
                blocksnapshot.restore(true, false);
                continue;
            }
            targets.add(position);
        }
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SymmetryEffectPacket(to, targets));
    }

    private static boolean isHoldingBlock(Player player, BlockState block) {
        ItemStack itemBlock = BlockHelper.getRequiredItem(block);
        return player.m_21205_().m_41656_(itemBlock) || player.m_21206_().m_41656_(itemBlock);
    }

    public static void remove(Level world, ItemStack wand, Player player, BlockPos pos) {
        BlockState air = Blocks.f_50016_.m_49966_();
        BlockState ogBlock = world.m_8055_(pos);
        SymmetryWandItem.checkNBT(wand);
        if (!SymmetryWandItem.isEnabled(wand)) {
            return;
        }
        HashMap<BlockPos, BlockState> blockSet = new HashMap<BlockPos, BlockState>();
        blockSet.put(pos, air);
        SymmetryMirror symmetry = SymmetryMirror.fromNBT(wand.m_41783_().m_128469_(SYMMETRY));
        Vec3 mirrorPos = symmetry.getPosition();
        if (mirrorPos.m_82554_(Vec3.m_82528_((Vec3i)pos)) > (double)((Integer)AllConfigs.SERVER.curiosities.maxSymmetryWandRange.get()).intValue()) {
            return;
        }
        symmetry.process(blockSet);
        BlockPos to = new BlockPos(mirrorPos);
        ArrayList<BlockPos> targets = new ArrayList<BlockPos>();
        targets.add(pos);
        for (BlockPos position : blockSet.keySet()) {
            BlockState blockstate;
            if (!player.m_7500_() && ogBlock.m_60734_() != world.m_8055_(position).m_60734_() || position.equals((Object)pos) || (blockstate = world.m_8055_(position)).m_60767_() == Material.f_76296_) continue;
            targets.add(position);
            world.m_46796_(2001, position, Block.m_49956_((BlockState)blockstate));
            world.m_7731_(position, air, 3);
            if (player.m_7500_()) continue;
            if (!player.m_21205_().m_41619_()) {
                player.m_21205_().m_41686_(world, blockstate, position, player);
            }
            BlockEntity tileentity = blockstate.m_155947_() ? world.m_7702_(position) : null;
            Block.m_49881_((BlockState)blockstate, (Level)world, (BlockPos)pos, (BlockEntity)tileentity, (Entity)player, (ItemStack)player.m_21205_());
        }
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SymmetryEffectPacket(to, targets));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(SimpleCustomRenderer.create(this, new SymmetryWandItemRenderer()));
    }
}

