/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.curiosities.toolbox.ToolboxBlock;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ToolBoxInstance
extends TileEntityInstance<ToolboxTileEntity>
implements IDynamicInstance {
    private final Direction facing;
    private ModelData lid;
    private ModelData[] drawers;

    public ToolBoxInstance(MaterialManager materialManager, ToolboxTileEntity tile) {
        super(materialManager, (BlockEntity)tile);
        this.facing = ((Direction)this.blockState.m_61143_((Property)ToolboxBlock.f_54117_)).m_122424_();
    }

    public void init() {
        BlockState blockState = ((ToolboxTileEntity)this.tile).m_58900_();
        Instancer drawerModel = this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllBlockPartials.TOOLBOX_DRAWER, blockState);
        this.drawers = new ModelData[]{(ModelData)drawerModel.createInstance(), (ModelData)drawerModel.createInstance()};
        this.lid = (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(AllBlockPartials.TOOLBOX_LIDS.get(((ToolboxTileEntity)this.tile).getColor()), blockState).createInstance();
    }

    public void remove() {
        this.lid.delete();
        for (ModelData drawer : this.drawers) {
            drawer.delete();
        }
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float lidAngle = ((ToolboxTileEntity)this.tile).lid.getValue(partialTicks);
        float drawerOffset = ((ToolboxTileEntity)this.tile).drawers.getValue(partialTicks);
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.lid.loadIdentity().translate((Vec3i)this.instancePos)).centre()).rotateY((double)(-this.facing.m_122435_()))).unCentre()).translate(0.0, 0.375, 0.75).rotateX((double)(135.0f * lidAngle))).translateBack(0.0, 0.375, 0.75);
        for (int offset : Iterate.zeroAndOne) {
            ((ModelData)((ModelData)((ModelData)((ModelData)this.drawers[offset].loadIdentity().translate((Vec3i)this.instancePos)).centre()).rotateY((double)(-this.facing.m_122435_()))).unCentre()).translate(0.0, (double)((float)(offset * 1) / 8.0f), (double)(-drawerOffset * 0.175f * (float)(2 - offset)));
        }
    }

    public void updateLight() {
        this.relight(this.pos, (IFlatLight[])this.drawers);
        this.relight(this.pos, new IFlatLight[]{this.lid});
    }
}

