/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.particle.AirParticleData;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonItem;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileEntity;
import com.simibubi.create.content.curiosities.zapper.ShootableGadgetRenderHandler;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PotatoCannonRenderHandler
extends ShootableGadgetRenderHandler {
    private float nextPitch;

    @Override
    protected void playSound(InteractionHand hand, Vec3 position) {
        PotatoProjectileEntity.playLaunchSound((Level)Minecraft.m_91087_().f_91073_, position, this.nextPitch);
    }

    @Override
    protected boolean appliesTo(ItemStack stack) {
        return ((PotatoCannonItem)((Object)AllItems.POTATO_CANNON.get())).isCannon(stack);
    }

    public void beforeShoot(float nextPitch, Vec3 location, Vec3 motion, ItemStack stack) {
        this.nextPitch = nextPitch;
        if (stack.m_41619_()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        for (int i = 0; i < 2; ++i) {
            Vec3 m = VecHelper.offsetRandomly(motion.m_82490_((double)0.1f), Create.RANDOM, 0.025f);
            world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), location.f_82479_, location.f_82480_, location.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
            Vec3 m2 = VecHelper.offsetRandomly(motion.m_82490_(2.0), Create.RANDOM, 0.5f);
            world.m_7106_((ParticleOptions)new AirParticleData(1.0f, 0.25f), location.f_82479_, location.f_82480_, location.f_82481_, m2.f_82479_, m2.f_82480_, m2.f_82481_);
        }
    }

    @Override
    protected void transformTool(PoseStack ms, float flip, float equipProgress, float recoil, float pt) {
        ms.m_85837_((double)(flip * -0.1f), 0.0, (double)0.14f);
        ms.m_85841_(0.75f, 0.75f, 0.75f);
        TransformStack.cast((PoseStack)ms).rotateX((double)(recoil * 80.0f));
    }

    @Override
    protected void transformHand(PoseStack ms, float flip, float equipProgress, float recoil, float pt) {
        ms.m_85837_((double)flip * -0.09, -0.275, -0.25);
        TransformStack.cast((PoseStack)ms).rotateZ((double)(flip * -10.0f));
    }
}

