/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonItem;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonProjectileType;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.registries.IRegistryDelegate;

public class PotatoProjectileTypeManager {
    private static final Map<ResourceLocation, PotatoCannonProjectileType> BUILTIN_TYPE_MAP = new HashMap<ResourceLocation, PotatoCannonProjectileType>();
    private static final Map<ResourceLocation, PotatoCannonProjectileType> CUSTOM_TYPE_MAP = new HashMap<ResourceLocation, PotatoCannonProjectileType>();
    private static final Map<IRegistryDelegate<Item>, PotatoCannonProjectileType> ITEM_TO_TYPE_MAP = new HashMap<IRegistryDelegate<Item>, PotatoCannonProjectileType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBuiltinType(ResourceLocation id, PotatoCannonProjectileType type) {
        Map<ResourceLocation, PotatoCannonProjectileType> map = BUILTIN_TYPE_MAP;
        synchronized (map) {
            BUILTIN_TYPE_MAP.put(id, type);
        }
    }

    public static PotatoCannonProjectileType getBuiltinType(ResourceLocation id) {
        return BUILTIN_TYPE_MAP.get(id);
    }

    public static PotatoCannonProjectileType getCustomType(ResourceLocation id) {
        return CUSTOM_TYPE_MAP.get(id);
    }

    public static PotatoCannonProjectileType getTypeForItem(IRegistryDelegate<Item> item) {
        return ITEM_TO_TYPE_MAP.get(item);
    }

    public static Optional<PotatoCannonProjectileType> getTypeForStack(ItemStack item) {
        if (item.m_41619_()) {
            return Optional.empty();
        }
        return Optional.ofNullable(PotatoProjectileTypeManager.getTypeForItem((IRegistryDelegate<Item>)item.m_41720_().delegate));
    }

    public static void clear() {
        CUSTOM_TYPE_MAP.clear();
        ITEM_TO_TYPE_MAP.clear();
    }

    public static void fillItemMap() {
        PotatoCannonProjectileType type;
        for (Map.Entry<ResourceLocation, PotatoCannonProjectileType> entry : BUILTIN_TYPE_MAP.entrySet()) {
            type = entry.getValue();
            for (IRegistryDelegate<Item> delegate : type.getItems()) {
                ITEM_TO_TYPE_MAP.put(delegate, type);
            }
        }
        for (Map.Entry<ResourceLocation, PotatoCannonProjectileType> entry : CUSTOM_TYPE_MAP.entrySet()) {
            type = entry.getValue();
            for (IRegistryDelegate<Item> delegate : type.getItems()) {
                ITEM_TO_TYPE_MAP.put(delegate, type);
            }
        }
        ITEM_TO_TYPE_MAP.remove(((PotatoCannonItem)((Object)AllItems.POTATO_CANNON.get())).delegate);
    }

    public static void toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130130_(CUSTOM_TYPE_MAP.size());
        for (Map.Entry<ResourceLocation, PotatoCannonProjectileType> entry : CUSTOM_TYPE_MAP.entrySet()) {
            buffer.m_130085_(entry.getKey());
            PotatoCannonProjectileType.toBuffer(entry.getValue(), buffer);
        }
    }

    public static void fromBuffer(FriendlyByteBuf buffer) {
        PotatoProjectileTypeManager.clear();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            CUSTOM_TYPE_MAP.put(buffer.m_130281_(), PotatoCannonProjectileType.fromBuffer(buffer));
        }
        PotatoProjectileTypeManager.fillItemMap();
    }

    public static void syncTo(ServerPlayer player) {
        AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncPacket());
    }

    public static void syncToAll() {
        AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new SyncPacket());
    }

    public static class SyncPacket
    extends SimplePacketBase {
        private FriendlyByteBuf buffer;

        public SyncPacket() {
        }

        public SyncPacket(FriendlyByteBuf buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            PotatoProjectileTypeManager.toBuffer(buffer);
        }

        @Override
        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> PotatoProjectileTypeManager.fromBuffer(this.buffer));
            context.get().setPacketHandled(true);
        }
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        protected ReloadListener() {
            super(GSON, "potato_cannon_projectile_types");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
            PotatoProjectileTypeManager.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                ResourceLocation id = entry.getKey();
                JsonObject object = element.getAsJsonObject();
                PotatoCannonProjectileType type = PotatoCannonProjectileType.fromJson(object);
                CUSTOM_TYPE_MAP.put(id, type);
            }
            PotatoProjectileTypeManager.fillItemMap();
        }
    }
}

