/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanBlock;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.particle.AirParticleData;
import com.simibubi.create.content.logistics.block.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.block.chute.ChuteBlock;
import com.simibubi.create.content.logistics.block.chute.ChuteItemHandler;
import com.simibubi.create.content.logistics.block.chute.SmartChuteTileEntity;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.InterpolatedValue;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChuteTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    float pull;
    float push;
    ItemStack item = ItemStack.f_41583_;
    InterpolatedValue itemPosition = new InterpolatedValue();
    ChuteItemHandler itemHandler = new ChuteItemHandler(this);
    LazyOptional<IItemHandler> lazyHandler = LazyOptional.of(() -> this.itemHandler);
    boolean canPickUpItems = false;
    float bottomPullDistance = 0.0f;
    float beltBelowOffset;
    TransportedItemStackHandlerBehaviour beltBelow;
    boolean updateAirFlow = true;
    int airCurrentUpdateCooldown;
    int entitySearchCooldown;
    LazyOptional<IItemHandler> capAbove = LazyOptional.empty();
    LazyOptional<IItemHandler> capBelow = LazyOptional.empty();

    public ChuteTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(d -> this.canDirectlyInsertCached()));
    }

    public boolean canDirectlyInsertCached() {
        return this.canPickUpItems;
    }

    private boolean canDirectlyInsert() {
        BlockState blockState = this.m_58900_();
        BlockState blockStateAbove = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        if (!AbstractChuteBlock.isChute(blockState)) {
            return false;
        }
        if (AbstractChuteBlock.getChuteFacing(blockStateAbove) == Direction.DOWN) {
            return false;
        }
        if (this.getItemMotion() > 0.0f && this.getInputChutes().isEmpty()) {
            return false;
        }
        return AbstractChuteBlock.isOpenChute(blockState);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.onAdded();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -3.0, 0.0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            this.canPickUpItems = this.canDirectlyInsert();
        }
        boolean clientSide = this.f_58857_ != null && this.f_58857_.f_46443_ && !this.isVirtual();
        float itemMotion = this.getItemMotion();
        if (itemMotion != 0.0f && this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.spawnParticles(itemMotion);
        }
        this.tickAirStreams(itemMotion);
        if (this.item.m_41619_() && !clientSide) {
            if (itemMotion < 0.0f) {
                this.handleInputFromAbove();
            }
            if (itemMotion > 0.0f) {
                this.handleInputFromBelow();
            }
            return;
        }
        float nextOffset = this.itemPosition.value + itemMotion;
        if (itemMotion < 0.0f) {
            if (nextOffset < 0.5f) {
                if (!this.handleDownwardOutput(true)) {
                    nextOffset = 0.5f;
                } else if (nextOffset < 0.0f) {
                    this.handleDownwardOutput(clientSide);
                    nextOffset = this.itemPosition.value;
                }
            }
        } else if (itemMotion > 0.0f && nextOffset > 0.5f) {
            if (!this.handleUpwardOutput(true)) {
                nextOffset = 0.5f;
            } else if (nextOffset > 1.0f) {
                this.handleUpwardOutput(clientSide);
                nextOffset = this.itemPosition.value;
            }
        }
        this.itemPosition.set(nextOffset);
    }

    private void updateAirFlow(float itemSpeed) {
        this.updateAirFlow = false;
        if (itemSpeed > 0.0f && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            float flowLimit;
            float speed = this.pull - this.push;
            this.beltBelow = null;
            float maxPullDistance = speed >= 128.0f ? 3.0f : (speed >= 64.0f ? 2.0f : (speed >= 32.0f ? 1.0f : Mth.m_14179_((float)(speed / 32.0f), (float)0.0f, (float)1.0f)));
            if (AbstractChuteBlock.isChute(this.f_58857_.m_8055_(this.f_58858_.m_7495_()))) {
                maxPullDistance = 0.0f;
            }
            if ((flowLimit = maxPullDistance) > 0.0f) {
                flowLimit = AirCurrent.getFlowLimit(this.f_58857_, this.f_58858_, maxPullDistance, Direction.DOWN);
            }
            int i = 1;
            while ((float)i <= flowLimit + 1.0f) {
                TransportedItemStackHandlerBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)this.f_58857_, this.f_58858_.m_6625_(i), TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour != null) {
                    this.beltBelow = behaviour;
                    this.beltBelowOffset = i - 1;
                    break;
                }
                ++i;
            }
            this.bottomPullDistance = Math.max(0.0f, flowLimit);
        }
        this.sendData();
    }

    private void findEntities(float itemSpeed) {
        if (this.bottomPullDistance <= 0.0f && !this.getItem().m_41619_() || itemSpeed <= 0.0f || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.canCollectItemsFromBelow()) {
            return;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        AABB searchArea = new AABB(center.m_82520_(0.0, (double)(-this.bottomPullDistance) - 0.5, 0.0), center.m_82520_(0.0, -0.5, 0.0)).m_82400_((double)0.45f);
        for (ItemEntity itemEntity : this.f_58857_.m_45976_(ItemEntity.class, searchArea)) {
            ItemStack entityItem;
            if (!itemEntity.m_6084_() || !this.canAcceptItem(entityItem = itemEntity.m_32055_())) continue;
            this.setItem(entityItem.m_41777_(), (float)(itemEntity.m_142469_().m_82399_().f_82480_ - (double)this.f_58858_.m_123342_()));
            itemEntity.m_146870_();
            AllTriggers.triggerForNearbyPlayers(AllTriggers.UPWARD_CHUTE, (LevelAccessor)this.f_58857_, this.f_58858_, 5);
            break;
        }
    }

    private void extractFromBelt(float itemSpeed) {
        if (itemSpeed <= 0.0f || this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.getItem().m_41619_() && this.beltBelow != null) {
            this.beltBelow.handleCenteredProcessingOnAllItems(0.5f, ts -> {
                if (this.canAcceptItem(ts.stack)) {
                    this.setItem(ts.stack.m_41777_(), -this.beltBelowOffset);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
                }
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    private void tickAirStreams(float itemSpeed) {
        if (!this.f_58857_.f_46443_ && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.SERVER.kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow(itemSpeed);
        }
        if (this.entitySearchCooldown-- <= 0 && this.item.m_41619_()) {
            this.entitySearchCooldown = 5;
            this.findEntities(itemSpeed);
        }
        this.extractFromBelt(itemSpeed);
    }

    public void blockBelowChanged() {
        this.updateAirFlow = true;
        this.capBelow = LazyOptional.empty();
    }

    private void spawnParticles(float itemMotion) {
        float absMotion;
        if (this.f_58857_ == null) {
            return;
        }
        BlockState blockState = this.m_58900_();
        boolean up = itemMotion > 0.0f;
        float f = absMotion = up ? itemMotion : -itemMotion;
        if (blockState == null || !AbstractChuteBlock.isChute(blockState)) {
            return;
        }
        if (this.push == 0.0f && this.pull == 0.0f) {
            return;
        }
        if (up && AbstractChuteBlock.isOpenChute(blockState) && BlockHelper.noCollisionInSpace((BlockGetter)this.f_58857_, this.f_58858_.m_7494_())) {
            this.spawnAirFlow(1.0f, 2.0f, absMotion, 0.5f);
        }
        if (AbstractChuteBlock.getChuteFacing(blockState) != Direction.DOWN) {
            return;
        }
        if (AbstractChuteBlock.isTransparentChute(blockState)) {
            this.spawnAirFlow(up ? 0.0f : 1.0f, up ? 1.0f : 0.0f, absMotion, 1.0f);
        }
        if (!up && BlockHelper.noCollisionInSpace((BlockGetter)this.f_58857_, this.f_58858_.m_7495_())) {
            this.spawnAirFlow(0.0f, -1.0f, absMotion, 0.5f);
        }
        if (up && this.canCollectItemsFromBelow() && this.bottomPullDistance > 0.0f) {
            this.spawnAirFlow(-this.bottomPullDistance, 0.0f, absMotion, 2.0f);
            this.spawnAirFlow(-this.bottomPullDistance, 0.0f, absMotion, 2.0f);
        }
    }

    private void spawnAirFlow(float verticalStart, float verticalEnd, float motion, float drag) {
        if (this.f_58857_ == null) {
            return;
        }
        AirParticleData airParticleData = new AirParticleData(drag, motion);
        Vec3 origin = Vec3.m_82528_((Vec3i)this.f_58858_);
        float xOff = Create.RANDOM.nextFloat() * 0.5f + 0.25f;
        float zOff = Create.RANDOM.nextFloat() * 0.5f + 0.25f;
        Vec3 v = origin.m_82520_((double)xOff, (double)verticalStart, (double)zOff);
        Vec3 d = origin.m_82520_((double)xOff, (double)verticalEnd, (double)zOff).m_82546_(v);
        if (Create.RANDOM.nextFloat() < 2.0f * motion) {
            this.f_58857_.m_7107_((ParticleOptions)airParticleData, v.f_82479_, v.f_82480_, v.f_82481_, d.f_82479_, d.f_82480_, d.f_82481_);
        }
    }

    private void handleInputFromAbove() {
        if (!this.capAbove.isPresent()) {
            this.capAbove = this.grabCapability(Direction.UP);
        }
        this.handleInput((IItemHandler)this.capAbove.orElse(null), 1.0f);
    }

    private void handleInputFromBelow() {
        if (!this.capBelow.isPresent()) {
            this.capBelow = this.grabCapability(Direction.DOWN);
        }
        this.handleInput((IItemHandler)this.capBelow.orElse(null), 0.0f);
    }

    private void handleInput(IItemHandler inv, float startLocation) {
        ItemStack extracted;
        if (inv == null) {
            return;
        }
        Predicate<ItemStack> canAccept = this::canAcceptItem;
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        if (!(mode != ItemHelper.ExtractionCountMode.UPTO && ItemHelper.extract(inv, canAccept, mode, count, true).m_41619_() || (extracted = ItemHelper.extract(inv, canAccept, mode, count, false)).m_41619_())) {
            this.setItem(extracted, startLocation);
        }
    }

    private boolean handleDownwardOutput(boolean simulate) {
        BlockState blockState = this.m_58900_();
        ChuteTileEntity targetChute = this.getTargetChute(blockState);
        Direction direction = AbstractChuteBlock.getChuteFacing(blockState);
        if (this.f_58857_ == null) {
            return false;
        }
        if (!this.capBelow.isPresent()) {
            this.capBelow = this.grabCapability(Direction.DOWN);
        }
        if (this.capBelow.isPresent()) {
            if (this.f_58857_.f_46443_ && !this.isVirtual()) {
                return false;
            }
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.capBelow.orElse(null)), (ItemStack)this.item, (boolean)simulate);
            ItemStack held = this.getItem();
            if (!simulate) {
                this.setItem(remainder, this.itemPosition.get(0.0f));
            }
            if (remainder.m_41613_() != held.m_41613_()) {
                return true;
            }
            if (direction == Direction.DOWN) {
                return false;
            }
        }
        if (targetChute != null) {
            boolean canInsert = targetChute.canAcceptItem(this.item);
            if (!simulate && canInsert) {
                targetChute.setItem(this.item, direction == Direction.DOWN ? 1.0f : 0.51f);
                this.setItem(ItemStack.f_41583_);
            }
            return canInsert;
        }
        if (direction.m_122434_().m_122479_()) {
            return false;
        }
        if (FunnelBlock.getFunnelFacing(this.f_58857_.m_8055_(this.f_58858_.m_7495_())) == Direction.DOWN) {
            return false;
        }
        if (Block.m_49936_((BlockGetter)this.f_58857_, (BlockPos)this.f_58858_.m_7495_())) {
            return false;
        }
        if (!simulate) {
            Vec3 dropVec = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82520_(0.0, -0.75, 0.0);
            ItemEntity dropped = new ItemEntity(this.f_58857_, dropVec.f_82479_, dropVec.f_82480_, dropVec.f_82481_, this.item.m_41777_());
            dropped.m_32060_();
            dropped.m_20334_(0.0, -0.25, 0.0);
            this.f_58857_.m_7967_((Entity)dropped);
            this.setItem(ItemStack.f_41583_);
        }
        return true;
    }

    private boolean handleUpwardOutput(boolean simulate) {
        BlockState stateAbove = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        if (this.f_58857_ == null) {
            return false;
        }
        if (AbstractChuteBlock.isOpenChute(this.m_58900_())) {
            if (!this.capAbove.isPresent()) {
                this.capAbove = this.grabCapability(Direction.UP);
            }
            if (this.capAbove.isPresent()) {
                if (this.f_58857_.f_46443_ && !this.isVirtual() && !ChuteBlock.isChute(stateAbove)) {
                    return false;
                }
                int countBefore = this.item.m_41613_();
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.capAbove.orElse(null)), (ItemStack)this.item, (boolean)simulate);
                if (!simulate) {
                    this.item = remainder;
                }
                return countBefore != remainder.m_41613_();
            }
        }
        ChuteTileEntity bestOutput = null;
        List<ChuteTileEntity> inputChutes = this.getInputChutes();
        for (ChuteTileEntity targetChute : inputChutes) {
            float itemMotion;
            if (!targetChute.canAcceptItem(this.item) || (itemMotion = targetChute.getItemMotion()) < 0.0f || bestOutput != null && !(bestOutput.getItemMotion() < itemMotion)) continue;
            bestOutput = targetChute;
        }
        if (bestOutput != null) {
            if (!simulate) {
                bestOutput.setItem(this.item, 0.0f);
                this.setItem(ItemStack.f_41583_);
            }
            return true;
        }
        if (FunnelBlock.getFunnelFacing(this.f_58857_.m_8055_(this.f_58858_.m_7494_())) == Direction.UP) {
            return false;
        }
        if (BlockHelper.hasBlockSolidSide(stateAbove, (BlockGetter)this.f_58857_, this.f_58858_.m_7494_(), Direction.DOWN)) {
            return false;
        }
        if (!inputChutes.isEmpty()) {
            return false;
        }
        if (!simulate) {
            Vec3 dropVec = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82520_(0.0, 0.5, 0.0);
            ItemEntity dropped = new ItemEntity(this.f_58857_, dropVec.f_82479_, dropVec.f_82480_, dropVec.f_82481_, this.item.m_41777_());
            dropped.m_32060_();
            dropped.m_20334_(0.0, (double)(this.getItemMotion() * 2.0f), 0.0);
            this.f_58857_.m_7967_((Entity)dropped);
            this.setItem(ItemStack.f_41583_);
        }
        return true;
    }

    protected boolean canAcceptItem(ItemStack stack) {
        return this.item.m_41619_();
    }

    protected int getExtractionAmount() {
        return 16;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return ItemHelper.ExtractionCountMode.UPTO;
    }

    protected boolean canCollectItemsFromBelow() {
        return true;
    }

    private LazyOptional<IItemHandler> grabCapability(Direction side) {
        BlockPos pos = this.f_58858_.m_142300_(side);
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        BlockEntity te = this.f_58857_.m_7702_(pos);
        if (te == null) {
            return LazyOptional.empty();
        }
        if (te instanceof ChuteTileEntity && (side != Direction.DOWN || !(te instanceof SmartChuteTileEntity) || this.getItemMotion() > 0.0f)) {
            return LazyOptional.empty();
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.m_122424_());
    }

    public void setItem(ItemStack stack) {
        this.setItem(stack, this.getItemMotion() < 0.0f ? 1.0f : 0.0f);
    }

    public void setItem(ItemStack stack, float insertionPos) {
        this.item = stack;
        this.itemPosition.lastValue = this.itemPosition.value = insertionPos;
        if (!this.f_58857_.f_46443_) {
            this.notifyUpdate();
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.lazyHandler != null) {
            this.lazyHandler.invalidate();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Item", (Tag)this.item.serializeNBT());
        compound.m_128350_("ItemPosition", this.itemPosition.value);
        compound.m_128350_("Pull", this.pull);
        compound.m_128350_("Push", this.push);
        compound.m_128350_("BottomAirFlowDistance", this.bottomPullDistance);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        ItemStack previousItem = this.item;
        this.item = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Item"));
        this.itemPosition.lastValue = this.itemPosition.value = compound.m_128457_("ItemPosition");
        this.pull = compound.m_128457_("Pull");
        this.push = compound.m_128457_("Push");
        this.bottomPullDistance = compound.m_128457_("BottomAirFlowDistance");
        super.fromTag(compound, clientPacket);
        if (this.m_58898_() && this.f_58857_ != null && this.f_58857_.f_46443_ && !previousItem.equals(this.item, false) && !this.item.m_41619_()) {
            if (this.f_58857_.f_46441_.nextInt(3) != 0) {
                return;
            }
            Vec3 p = VecHelper.getCenterOf((Vec3i)this.f_58858_);
            p = VecHelper.offsetRandomly(p, this.f_58857_.f_46441_, 0.5f);
            Vec3 m = Vec3.f_82478_;
            this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.item), p.f_82479_, p.f_82480_, p.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public float getItemMotion() {
        float fanSpeedModifier = 0.015625f;
        float maxItemSpeed = 20.0f;
        float gravity = 4.0f;
        float motion = (this.push + this.pull) * 0.015625f;
        return (Mth.m_14036_((float)motion, (float)-20.0f, (float)20.0f) + (motion <= 0.0f ? -4.0f : 0.0f)) / 20.0f;
    }

    public void onRemoved(BlockState chuteState) {
        ChuteTileEntity targetChute = this.getTargetChute(chuteState);
        List<ChuteTileEntity> inputChutes = this.getInputChutes();
        if (!this.item.m_41619_() && this.f_58857_ != null) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.item);
        }
        this.m_7651_();
        if (targetChute != null) {
            targetChute.updatePull();
            targetChute.propagatePush();
        }
        inputChutes.forEach(c -> c.updatePush(inputChutes.size()));
    }

    public void onAdded() {
        this.refreshBlockState();
        this.updatePull();
        ChuteTileEntity targetChute = this.getTargetChute(this.m_58900_());
        if (targetChute != null) {
            targetChute.propagatePush();
        } else {
            this.updatePush(1);
        }
    }

    public void updatePull() {
        float totalPull = this.calculatePull();
        if (this.pull == totalPull) {
            return;
        }
        this.pull = totalPull;
        this.updateAirFlow = true;
        this.sendData();
        ChuteTileEntity targetChute = this.getTargetChute(this.m_58900_());
        if (targetChute != null) {
            targetChute.updatePull();
        }
    }

    public void updatePush(int branchCount) {
        float totalPush = this.calculatePush(branchCount);
        if (this.push == totalPush) {
            return;
        }
        this.updateAirFlow = true;
        this.push = totalPush;
        this.sendData();
        this.propagatePush();
    }

    public void propagatePush() {
        List<ChuteTileEntity> inputs = this.getInputChutes();
        inputs.forEach(c -> c.updatePush(inputs.size()));
    }

    protected float calculatePull() {
        BlockEntity te;
        BlockState blockStateAbove = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        if (AllBlocks.ENCASED_FAN.has(blockStateAbove) && blockStateAbove.m_61143_((Property)EncasedFanBlock.FACING) == Direction.DOWN && (te = this.f_58857_.m_7702_(this.f_58858_.m_7494_())) instanceof EncasedFanTileEntity && !te.m_58901_()) {
            EncasedFanTileEntity fan = (EncasedFanTileEntity)te;
            return fan.getSpeed();
        }
        float totalPull = 0.0f;
        for (Direction d : Iterate.directions) {
            ChuteTileEntity inputChute = this.getInputChute(d);
            if (inputChute == null) continue;
            totalPull += inputChute.pull;
        }
        return totalPull;
    }

    protected float calculatePush(int branchCount) {
        BlockEntity te;
        if (this.f_58857_ == null) {
            return 0.0f;
        }
        BlockState blockStateBelow = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        if (AllBlocks.ENCASED_FAN.has(blockStateBelow) && blockStateBelow.m_61143_((Property)EncasedFanBlock.FACING) == Direction.UP && (te = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) instanceof EncasedFanTileEntity && !te.m_58901_()) {
            EncasedFanTileEntity fan = (EncasedFanTileEntity)te;
            return fan.getSpeed();
        }
        ChuteTileEntity targetChute = this.getTargetChute(this.m_58900_());
        if (targetChute == null) {
            return 0.0f;
        }
        return targetChute.push / (float)branchCount;
    }

    @Nullable
    private ChuteTileEntity getTargetChute(BlockState state) {
        BlockState chuteState;
        if (this.f_58857_ == null) {
            return null;
        }
        Direction targetDirection = AbstractChuteBlock.getChuteFacing(state);
        if (targetDirection == null) {
            return null;
        }
        BlockPos chutePos = this.f_58858_.m_7495_();
        if (targetDirection.m_122434_().m_122479_()) {
            chutePos = chutePos.m_142300_(targetDirection.m_122424_());
        }
        if (!AbstractChuteBlock.isChute(chuteState = this.f_58857_.m_8055_(chutePos))) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(chutePos);
        if (te instanceof ChuteTileEntity) {
            return (ChuteTileEntity)te;
        }
        return null;
    }

    private List<ChuteTileEntity> getInputChutes() {
        LinkedList<ChuteTileEntity> inputs = new LinkedList<ChuteTileEntity>();
        for (Direction d : Iterate.directions) {
            ChuteTileEntity inputChute = this.getInputChute(d);
            if (inputChute == null) continue;
            inputs.add(inputChute);
        }
        return inputs;
    }

    @Nullable
    private ChuteTileEntity getInputChute(Direction direction) {
        BlockState chuteState;
        Direction chuteFacing;
        if (this.f_58857_ == null || direction == Direction.DOWN) {
            return null;
        }
        direction = direction.m_122424_();
        BlockPos chutePos = this.f_58858_.m_7494_();
        if (direction.m_122434_().m_122479_()) {
            chutePos = chutePos.m_142300_(direction);
        }
        if ((chuteFacing = AbstractChuteBlock.getChuteFacing(chuteState = this.f_58857_.m_8055_(chutePos))) != direction) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(chutePos);
        if (te instanceof ChuteTileEntity && !te.m_58901_()) {
            return (ChuteTileEntity)te;
        }
        return null;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean downward = this.getItemMotion() < 0.0f;
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("tooltip.chute.header", new Object[0])));
        if (this.pull == 0.0f && this.push == 0.0f) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("tooltip.chute.no_fans_attached", new Object[0])).m_130940_(ChatFormatting.GRAY));
        }
        if (this.pull != 0.0f) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("tooltip.chute.fans_" + (this.pull > 0.0f ? "pull_up" : "push_down"), new Object[0]).m_130940_(ChatFormatting.GRAY)));
        }
        if (this.push != 0.0f) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("tooltip.chute.fans_" + (this.push > 0.0f ? "push_up" : "pull_down"), new Object[0]).m_130940_(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)componentSpacing.m_6879_().m_130946_("-> ").m_7220_((Component)Lang.translate("tooltip.chute.items_move_" + (downward ? "down" : "up"), new Object[0]).m_130940_(ChatFormatting.YELLOW)));
        if (!this.item.m_41619_()) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("tooltip.chute.contains", new TranslatableComponent(this.item.m_41720_().m_5671_(this.item)).getString(), this.item.m_41613_())).m_130940_(ChatFormatting.GREEN));
        }
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack getItem() {
        return this.item;
    }
}

