/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.content.logistics.block.depot.EjectorRenderer;
import com.simibubi.create.content.logistics.block.depot.EjectorTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;

public class EjectorInstance
extends ShaftInstance
implements IDynamicInstance {
    protected final EjectorTileEntity tile;
    protected final ModelData plate;
    private float lastProgress = Float.NaN;

    public EjectorInstance(MaterialManager dispatcher, EjectorTileEntity tile) {
        super(dispatcher, tile);
        this.tile = tile;
        this.plate = (ModelData)this.getTransformMaterial().getModel(AllBlockPartials.EJECTOR_TOP, this.blockState).createInstance();
        this.pivotPlate();
    }

    public void beginFrame() {
        float lidProgress = this.getLidProgress();
        if (Mth.m_14033_((float)lidProgress, (float)this.lastProgress)) {
            return;
        }
        this.pivotPlate(lidProgress);
        this.lastProgress = lidProgress;
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new IFlatLight[]{this.plate});
    }

    @Override
    public void remove() {
        super.remove();
        this.plate.delete();
    }

    private void pivotPlate() {
        this.pivotPlate(this.getLidProgress());
    }

    private float getLidProgress() {
        return this.tile.getLidProgress(AnimationTickHolder.getPartialTicks());
    }

    private void pivotPlate(float lidProgress) {
        float angle = lidProgress * 70.0f;
        EjectorRenderer.applyLidAngle(this.tile, angle, (ModelData)this.plate.loadIdentity().translate((Vec3i)this.getInstancePosition()));
    }
}

