/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.Rotate;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.jozufozu.flywheel.util.transform.Translate;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.block.depot.DepotRenderer;
import com.simibubi.create.content.logistics.block.depot.EjectorBlock;
import com.simibubi.create.content.logistics.block.depot.EjectorTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EjectorRenderer
extends KineticTileEntityRenderer {
    static final Vec3 pivot = VecHelper.voxelSpace(0.0, 11.25, 0.75);

    public EjectorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(KineticTileEntity p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        EjectorTileEntity ejector = (EjectorTileEntity)te;
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110451_());
        float lidProgress = ((EjectorTileEntity)te).getLidProgress(partialTicks);
        float angle = lidProgress * 70.0f;
        if (!Backend.getInstance().canUseInstancing(te.m_58904_())) {
            SuperByteBuffer model = CachedBufferer.partial(AllBlockPartials.EJECTOR_TOP, te.m_58900_());
            EjectorRenderer.applyLidAngle(te, angle, model);
            model.light(light).renderInto(ms, vertexBuilder);
        }
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        float maxTime = (float)(ejector.earlyTarget != null ? (double)ejector.earlyTargetTime : ejector.launcher.getTotalFlyingTicks());
        for (IntAttached<ItemStack> intAttached : ejector.launchedItems) {
            float time = (float)((Integer)intAttached.getFirst()).intValue() + partialTicks;
            if (time > maxTime) continue;
            ms.m_85836_();
            Vec3 launchedItemLocation = ejector.getLaunchedItemLocation(time);
            msr.translate(launchedItemLocation.m_82546_(Vec3.m_82528_((Vec3i)te.m_58899_())));
            Vec3 itemRotOffset = VecHelper.voxelSpace(0.0, 3.0, 0.0);
            msr.translate(itemRotOffset);
            msr.rotateY((double)AngleHelper.horizontalAngle(ejector.getFacing()));
            msr.rotateX((double)(time * 40.0f));
            msr.translateBack(itemRotOffset);
            Minecraft.m_91087_().m_91291_().m_174269_(intAttached.getValue(), ItemTransforms.TransformType.GROUND, light, overlay, ms, buffer, 0);
            ms.m_85849_();
        }
        DepotBehaviour behaviour = te.getBehaviour(DepotBehaviour.TYPE);
        if (behaviour == null || behaviour.isEmpty()) {
            return;
        }
        ms.m_85836_();
        EjectorRenderer.applyLidAngle(te, angle, msr);
        ((TransformStack)((TransformStack)msr.centre()).rotateY((double)(-180.0f - AngleHelper.horizontalAngle((Direction)te.m_58900_().m_61143_(EjectorBlock.HORIZONTAL_FACING))))).unCentre();
        DepotRenderer.renderItemsOf(te, partialTicks, ms, buffer, light, overlay, behaviour);
        ms.m_85849_();
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticTileEntity te, float angle, T tr) {
        EjectorRenderer.applyLidAngle(te, pivot, angle, tr);
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticTileEntity te, Vec3 rotationOffset, float angle, T tr) {
        ((Translate)((Rotate)((Translate)((Translate)((Translate)((Rotate)((Translate)tr.centre())).rotateY((double)(180.0f + AngleHelper.horizontalAngle((Direction)te.m_58900_().m_61143_(EjectorBlock.HORIZONTAL_FACING))))).unCentre()).translate(rotationOffset))).rotateX((double)(-angle))).translateBack(rotationOffset);
    }

    @Override
    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return EjectorRenderer.shaft(EjectorRenderer.getRotationAxisOf(te));
    }
}

