/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.diodes;

import com.jozufozu.flywheel.backend.instancing.IInstanceRendered;
import com.simibubi.create.content.logistics.block.diodes.BrassDiodeBlock;
import com.simibubi.create.content.logistics.block.diodes.BrassDiodeScrollSlot;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BrassDiodeTileEntity
extends SmartTileEntity
implements IInstanceRendered {
    protected int state;
    ScrollValueBehaviour maxState;

    public BrassDiodeTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.maxState = new ScrollValueBehaviour((Component)Lang.translate("generic.delay", new Object[0]), this, new BrassDiodeScrollSlot()).between(2, 36000);
        this.maxState.withStepFunction(this::step);
        this.maxState.withFormatter(this::format);
        this.maxState.withUnit(this::getUnit);
        this.maxState.withCallback(this::onMaxDelayChanged);
        behaviours.add(this.maxState);
    }

    public float getProgress() {
        int max = Math.max(2, this.maxState.getValue());
        return (float)Mth.m_14045_((int)this.state, (int)0, (int)max) / (float)max;
    }

    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public void tick() {
        super.tick();
        boolean powered = (Boolean)this.m_58900_().m_61143_((Property)DiodeBlock.f_52496_);
        boolean powering = (Boolean)this.m_58900_().m_61143_((Property)BrassDiodeBlock.POWERING);
        boolean atMax = this.state >= this.maxState.getValue();
        boolean atMin = this.state <= 0;
        this.updateState(powered, powering, atMax, atMin);
    }

    protected abstract void updateState(boolean var1, boolean var2, boolean var3, boolean var4);

    private void onMaxDelayChanged(int newMax) {
        this.state = Mth.m_14045_((int)this.state, (int)0, (int)newMax);
        this.sendData();
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        this.state = compound.m_128451_("State");
        super.fromTag(compound, clientPacket);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("State", this.state);
        super.write(compound, clientPacket);
    }

    private int step(ScrollValueBehaviour.StepContext context) {
        int value = context.currentValue;
        if (!context.forward) {
            --value;
        }
        if (value < 20) {
            return 1;
        }
        if (value < 1200) {
            return 20;
        }
        return 1200;
    }

    private String format(int value) {
        if (value < 20) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    private Component getUnit(int value) {
        if (value < 20) {
            return Lang.translate("generic.unit.ticks", new Object[0]);
        }
        if (value < 1200) {
            return Lang.translate("generic.unit.seconds", new Object[0]);
        }
        return Lang.translate("generic.unit.minutes", new Object[0]);
    }
}

