/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FunnelMovementBehaviour
extends MovementBehaviour {
    private final boolean hasFilter;

    public static FunnelMovementBehaviour andesite() {
        return new FunnelMovementBehaviour(false);
    }

    public static FunnelMovementBehaviour brass() {
        return new FunnelMovementBehaviour(true);
    }

    private FunnelMovementBehaviour(boolean hasFilter) {
        this.hasFilter = hasFilter;
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        Direction facing = FunnelBlock.getFunnelFacing(context.state);
        Vec3 vec = Vec3.m_82528_((Vec3i)facing.m_122436_());
        if (facing != Direction.UP) {
            return vec.m_82490_((Boolean)context.state.m_61143_((Property)FunnelBlock.EXTRACTING) != false ? 0.15 : 0.65);
        }
        return vec.m_82490_(0.65);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        if (((Boolean)context.state.m_61143_((Property)FunnelBlock.EXTRACTING)).booleanValue()) {
            this.extract(context, pos);
        } else {
            this.succ(context, pos);
        }
    }

    private void extract(MovementContext context, BlockPos pos) {
        ItemStack extract;
        Level world = context.world;
        Vec3 entityPos = context.position;
        if (context.state.m_61143_((Property)FunnelBlock.FACING) != Direction.DOWN) {
            entityPos = entityPos.m_82520_(0.0, -0.5, 0.0);
        }
        if (!world.m_8055_(pos).m_60812_((BlockGetter)world, pos).m_83281_()) {
            return;
        }
        if (!world.m_45976_(ItemEntity.class, new AABB(new BlockPos(entityPos))).isEmpty()) {
            return;
        }
        ItemStack filter = this.getFilter(context);
        int filterAmount = context.tileData.m_128451_("FilterAmount");
        if (filterAmount <= 0) {
            int n = filterAmount = this.hasFilter ? (Integer)AllConfigs.SERVER.logistics.defaultExtractionLimit.get() : 1;
        }
        if ((extract = ItemHelper.extract((IItemHandler)context.contraption.inventory, s -> FilterItem.test(world, s, filter), ItemHelper.ExtractionCountMode.UPTO, filterAmount, false)).m_41619_()) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        ItemEntity entity = new ItemEntity(world, entityPos.f_82479_, entityPos.f_82480_, entityPos.f_82481_, extract);
        entity.m_20256_(Vec3.f_82478_);
        entity.m_32010_(5);
        world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.0625f, 0.1f);
        world.m_7967_((Entity)entity);
    }

    private void succ(MovementContext context, BlockPos pos) {
        Level world = context.world;
        List items = world.m_45976_(ItemEntity.class, new AABB(pos));
        ItemStack filter = this.getFilter(context);
        for (ItemEntity item : items) {
            ItemStack remainder;
            if (!item.m_6084_()) continue;
            ItemStack toInsert = item.m_32055_();
            if (!filter.m_41619_() && !FilterItem.test(context.world, toInsert, filter) || (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)context.contraption.inventory, (ItemStack)toInsert, (boolean)false)).m_41613_() == toInsert.m_41613_()) continue;
            if (remainder.m_41619_()) {
                item.m_32045_(ItemStack.f_41583_);
                item.m_146870_();
                continue;
            }
            item.m_32045_(remainder);
        }
    }

    @Override
    public boolean renderAsNormalTileEntity() {
        return true;
    }

    private ItemStack getFilter(MovementContext context) {
        return this.hasFilter ? ItemStack.m_41712_((CompoundTag)context.tileData.m_128469_("Filter")) : ItemStack.f_41583_;
    }
}

