/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverBlock;
import com.simibubi.create.content.logistics.block.redstone.AnalogLeverTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class AnalogLeverRenderer
extends SafeTileEntityRenderer<AnalogLeverTileEntity> {
    public AnalogLeverRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(AnalogLeverTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.getInstance().canUseInstancing(te.m_58904_())) {
            return;
        }
        BlockState leverState = te.m_58900_();
        float state = te.clientState.get(partialTicks);
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        SuperByteBuffer handle = CachedBufferer.partial(AllBlockPartials.ANALOG_LEVER_HANDLE, leverState);
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        ((SuperByteBuffer)this.transform(handle, leverState).translate(0.5, 0.0625, 0.5).rotate(Direction.EAST, angle)).translate(-0.5, -0.0625, -0.5);
        handle.light(light).renderInto(ms, vb);
        int color = Color.mixColors(2884352, 0xCD0000, state / 15.0f);
        SuperByteBuffer indicator = this.transform(CachedBufferer.partial(AllBlockPartials.ANALOG_LEVER_INDICATOR, leverState), leverState);
        indicator.light(light).color(color).renderInto(ms, vb);
    }

    private SuperByteBuffer transform(SuperByteBuffer buffer, BlockState leverState) {
        AttachFace face = (AttachFace)leverState.m_61143_((Property)AnalogLeverBlock.f_53179_);
        float rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        float rY = AngleHelper.horizontalAngle((Direction)leverState.m_61143_((Property)AnalogLeverBlock.f_54117_));
        buffer.rotateCentered(Direction.UP, (float)((double)(rY / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.EAST, (float)((double)(rX / 180.0f) * Math.PI));
        return buffer;
    }
}

