/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeTileEntity;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NixieTubeBlock
extends HorizontalDirectionalBlock
implements ITE<NixieTubeTileEntity>,
IWrenchable,
ISpecialBlockItemRequirement {
    public static final BooleanProperty CEILING = BooleanProperty.m_61465_((String)"ceiling");
    protected final DyeColor color;

    public NixieTubeBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CEILING, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockPos nextPos;
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        NixieTubeTileEntity nixie = (NixieTubeTileEntity)this.getTileEntity((BlockGetter)world, pos);
        if (nixie == null) {
            return InteractionResult.PASS;
        }
        if (heldItem.m_41619_()) {
            if (nixie.reactsToRedstone()) {
                return InteractionResult.PASS;
            }
            nixie.clearCustomText();
            this.updateDisplayedRedstoneValue(state, world, pos);
            return InteractionResult.SUCCESS;
        }
        boolean display = heldItem.m_41720_() == Items.f_42656_ && heldItem.m_41788_();
        DyeColor dye = DyeColor.getColor((ItemStack)heldItem);
        if (!display && dye == null) {
            return InteractionResult.PASS;
        }
        Direction left = ((Direction)state.m_61143_((Property)f_54117_)).m_122427_();
        Direction right = left.m_122424_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos currentPos = pos;
        while (NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(nextPos = currentPos.m_142300_(left)), state)) {
            currentPos = nextPos;
        }
        int index = 0;
        while (true) {
            BlockPos nextPos2;
            int rowPosition = ++index;
            if (display) {
                this.withTileEntityDo((BlockGetter)world, currentPos, te -> te.displayCustomNameOf(heldItem, rowPosition));
            }
            if (dye != null) {
                world.m_46597_(currentPos, NixieTubeBlock.withColor(state, dye));
            }
            if (!NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(nextPos2 = currentPos.m_142300_(right)), state)) break;
            currentPos = nextPos2;
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{CEILING, f_54117_}));
    }

    public void m_6810_(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!(p_196243_4_.m_60734_() instanceof NixieTubeBlock)) {
            p_196243_2_.m_46747_(p_196243_3_);
        }
    }

    public ItemStack m_7397_(BlockGetter p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return AllBlocks.ORANGE_NIXIE_TUBE.asStack();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity te) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, ((NixieTubeBlock)AllBlocks.ORANGE_NIXIE_TUBE.get()).m_5456_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return ((Boolean)state.m_61143_((Property)CEILING) != false ? AllShapes.NIXIE_TUBE_CEILING : AllShapes.NIXIE_TUBE).get(((Direction)state.m_61143_((Property)f_54117_)).m_122434_());
    }

    public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (this.color != DyeColor.ORANGE) {
            return ((NixieTubeBlock)AllBlocks.ORANGE_NIXIE_TUBE.get()).getPickBlock(state, target, world, pos, player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        boolean ceiling = context.m_43719_() == Direction.DOWN;
        Vec3 hitVec = context.m_43720_();
        if (hitVec != null) {
            ceiling = hitVec.f_82480_ - (double)pos.m_123342_() > 0.5;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)CEILING, (Comparable)Boolean.valueOf(ceiling));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (worldIn.f_46443_) {
            return;
        }
        if (!worldIn.m_6219_().m_5913_(pos, (Object)this)) {
            worldIn.m_6219_().m_5945_(pos, (Object)this, 0);
        }
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random r) {
        this.updateDisplayedRedstoneValue(state, (Level)worldIn, pos);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() == oldState.m_60734_() || isMoving) {
            return;
        }
        this.updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    private void updateDisplayedRedstoneValue(BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn.f_46443_) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            if (te.reactsToRedstone()) {
                te.updateRedstoneStrength(this.getPower(worldIn, pos));
            }
        });
    }

    static boolean isValidBlock(BlockGetter world, BlockPos pos, boolean above) {
        BlockState state = world.m_8055_(pos.m_6630_(above ? 1 : -1));
        return !state.m_60808_(world, pos).m_83281_();
    }

    private int getPower(Level worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_46681_(pos.m_142300_(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_46681_(pos.m_142300_(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null;
    }

    @Override
    public Class<NixieTubeTileEntity> getTileEntityClass() {
        return NixieTubeTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends NixieTubeTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.NIXIE_TUBE.get();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static boolean areNixieBlocksEqual(BlockState blockState, BlockState otherState) {
        if (!(blockState.m_60734_() instanceof NixieTubeBlock)) {
            return false;
        }
        if (!(otherState.m_60734_() instanceof NixieTubeBlock)) {
            return false;
        }
        return NixieTubeBlock.withColor(blockState, DyeColor.WHITE) == NixieTubeBlock.withColor(otherState, DyeColor.WHITE);
    }

    public static BlockState withColor(BlockState state, DyeColor color) {
        return (BlockState)((BlockState)(color == DyeColor.ORANGE ? AllBlocks.ORANGE_NIXIE_TUBE : AllBlocks.NIXIE_TUBES.get(color)).getDefaultState().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)CEILING, (Comparable)((Boolean)state.m_61143_((Property)CEILING)));
    }

    public static DyeColor colorOf(BlockState blockState) {
        return blockState.m_60734_() instanceof NixieTubeBlock ? ((NixieTubeBlock)blockState.m_60734_()).color : DyeColor.ORANGE;
    }
}

