/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneLinkBlock
extends WrenchableDirectionalBlock
implements ITE<RedstoneLinkTileEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty RECEIVER = BooleanProperty.m_61465_((String)"receiver");

    public RedstoneLinkBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RECEIVER, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        Direction blockFacing = (Direction)state.m_61143_((Property)f_52588_);
        if (fromPos.equals((Object)pos.m_142300_(blockFacing.m_122424_())) && !this.m_7898_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
            return;
        }
        if (!worldIn.m_6219_().m_5913_(pos, (Object)this)) {
            worldIn.m_6219_().m_5945_(pos, (Object)this, 0);
        }
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random r) {
        this.updateTransmittedSignal(state, (Level)worldIn, pos);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() == oldState.m_60734_() || isMoving) {
            return;
        }
        this.updateTransmittedSignal(state, worldIn, pos);
    }

    public void updateTransmittedSignal(BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn.f_46443_) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)RECEIVER)).booleanValue()) {
            return;
        }
        int power = this.getPower(worldIn, pos);
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != power > 0) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
        int transmit = power;
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> te.transmit(transmit));
    }

    private int getPower(Level worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_46681_(pos.m_142300_(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_46681_(pos.m_142300_(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && (Boolean)state.m_61143_((Property)RECEIVER) != false;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (side != blockState.m_61143_((Property)f_52588_)) {
            return 0;
        }
        return this.m_6378_(blockState, blockAccess, pos, side);
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)state.m_61143_((Property)RECEIVER)).booleanValue()) {
            return 0;
        }
        return this.getTileEntityOptional(blockAccess, pos).map(RedstoneLinkTileEntity::getReceivedSignal).orElse(0);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, RECEIVER});
        super.m_7926_(builder);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6144_()) {
            return this.toggleMode(state, worldIn, pos);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult toggleMode(BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return this.onTileEntityUse((BlockGetter)worldIn, pos, te -> {
            Boolean wasReceiver = (Boolean)state.m_61143_((Property)RECEIVER);
            boolean blockPowered = worldIn.m_46753_(pos);
            worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61122_((Property)RECEIVER)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(blockPowered)), 3);
            te.transmit(wasReceiver != false ? 0 : this.getPower(worldIn, pos));
            return InteractionResult.SUCCESS;
        });
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (this.toggleMode(state, context.m_43725_(), context.m_8083_()) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return super.onWrenched(state, context);
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction _targetedFace) {
        return originalState;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos neighbourPos = pos.m_142300_(((Direction)state.m_61143_((Property)f_52588_)).m_122424_());
        BlockState neighbour = worldIn.m_8055_(neighbourPos);
        return !neighbour.m_60767_().m_76336_();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        state = (BlockState)state.m_61124_((Property)f_52588_, (Comparable)context.m_43719_());
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.REDSTONE_BRIDGE.get((Direction)state.m_61143_((Property)f_52588_));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public Class<RedstoneLinkTileEntity> getTileEntityClass() {
        return RedstoneLinkTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends RedstoneLinkTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.REDSTONE_LINK.get();
    }
}

