/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkBlock;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkFrequencySlot;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneLinkTileEntity
extends SmartTileEntity {
    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    private LinkBehaviour link;
    private boolean transmitter;

    public RedstoneLinkTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        Pair<ValueBoxTransform, ValueBoxTransform> slots = ValueBoxTransform.Dual.makeSlots(RedstoneLinkFrequencySlot::new);
        this.link = this.transmitter ? LinkBehaviour.transmitter(this, slots, this::getSignal) : LinkBehaviour.receiver(this, slots, this::setSignal);
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void setSignal(int power) {
        if (this.receivedSignal != power) {
            this.receivedSignalChanged = true;
        }
        this.receivedSignal = power;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Transmitter", this.transmitter);
        compound.m_128405_("Receive", this.getReceivedSignal());
        compound.m_128379_("ReceivedChanged", this.receivedSignalChanged);
        compound.m_128405_("Transmit", this.transmittedSignal);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        this.transmitter = compound.m_128471_("Transmitter");
        super.fromTag(compound, clientPacket);
        this.receivedSignal = compound.m_128451_("Receive");
        this.receivedSignalChanged = compound.m_128471_("ReceivedChanged");
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || !this.link.newPosition) {
            this.transmittedSignal = compound.m_128451_("Transmit");
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            LinkBehaviour prevlink = this.link;
            this.removeBehaviour(LinkBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.attachBehaviourLate(this.link);
        }
        if (this.transmitter) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.REDSTONE_LINK.has(blockState)) {
            return;
        }
        if (this.getReceivedSignal() > 0 != (Boolean)blockState.m_61143_((Property)RedstoneLinkBlock.POWERED)) {
            this.receivedSignalChanged = true;
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61122_((Property)RedstoneLinkBlock.POWERED));
        }
        if (this.receivedSignalChanged) {
            Direction attachedFace = ((Direction)blockState.m_61143_((Property)RedstoneLinkBlock.f_52588_)).m_122424_();
            BlockPos attachedPos = this.f_58858_.m_142300_(attachedFace);
            this.f_58857_.m_6289_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_).m_60734_());
            this.f_58857_.m_6289_(attachedPos, this.f_58857_.m_8055_(attachedPos).m_60734_());
            this.receivedSignalChanged = false;
        }
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.m_58900_().m_61143_((Property)RedstoneLinkBlock.RECEIVER) == false;
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }
}

