/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.logistics.block.redstone.FilteredDetectorFilterSlot;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.TankManipulationBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.TickList;
import net.minecraft.world.level.TickPriority;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class StockpileSwitchTileEntity
extends SmartTileEntity {
    public float onWhenAbove = 0.75f;
    public float offWhenBelow = 0.25f;
    public float currentLevel = -1.0f;
    private boolean redstoneState = false;
    private boolean inverted = false;
    private boolean poweredAfterDelay = false;
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;

    public StockpileSwitchTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    protected void fromTag(CompoundTag compound, boolean clientPacket) {
        this.onWhenAbove = compound.m_128457_("OnAbove");
        this.offWhenBelow = compound.m_128457_("OffBelow");
        this.currentLevel = compound.m_128457_("Current");
        this.redstoneState = compound.m_128471_("Powered");
        this.inverted = compound.m_128471_("Inverted");
        this.poweredAfterDelay = compound.m_128471_("PoweredAfterDelay");
        super.fromTag(compound, clientPacket);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("OnAbove", this.onWhenAbove);
        compound.m_128350_("OffBelow", this.offWhenBelow);
        compound.m_128350_("Current", this.currentLevel);
        compound.m_128379_("Powered", this.redstoneState);
        compound.m_128379_("Inverted", this.inverted);
        compound.m_128379_("PoweredAfterDelay", this.poweredAfterDelay);
        super.write(compound, clientPacket);
    }

    public float getStockLevel() {
        return this.currentLevel;
    }

    public void updateCurrentLevel() {
        float stockLevel;
        boolean changed = false;
        float occupied = 0.0f;
        float totalSpace = 0.0f;
        this.observedInventory.findNewCapability();
        if (this.observedInventory.hasInventory()) {
            IItemHandler inv = (IItemHandler)this.observedInventory.getInventory();
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                stackInSlot = inv.getStackInSlot(slot);
                space = Math.min(stackInSlot.m_41741_(), inv.getSlotLimit(slot));
                int count = stackInSlot.m_41613_();
                if (space == 0) continue;
                totalSpace += 1.0f;
                if (!this.filtering.test(stackInSlot)) continue;
                occupied += (float)count * (1.0f / (float)space);
            }
        } else {
            this.observedTank.findNewCapability();
            if (this.observedTank.hasInventory()) {
                IFluidHandler tank = (IFluidHandler)this.observedTank.getInventory();
                for (slot = 0; slot < tank.getTanks(); ++slot) {
                    stackInSlot = tank.getFluidInTank(slot);
                    space = tank.getTankCapacity(slot);
                    int count = stackInSlot.getAmount();
                    if (space == 0) continue;
                    totalSpace += 1.0f;
                    if (!this.filtering.test((FluidStack)stackInSlot)) continue;
                    occupied += (float)count * (1.0f / (float)space);
                }
            } else {
                if (this.currentLevel == -1.0f) {
                    return;
                }
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)StockpileSwitchBlock.INDICATOR, (Comparable)Integer.valueOf(0)), 3);
                this.currentLevel = -1.0f;
                this.redstoneState = false;
                this.sendData();
                this.scheduleBlockTick();
                return;
            }
        }
        if (this.currentLevel != (stockLevel = occupied / totalSpace)) {
            changed = true;
        }
        this.currentLevel = stockLevel;
        this.currentLevel = Mth.m_14036_((float)this.currentLevel, (float)0.0f, (float)1.0f);
        boolean previouslyPowered = this.redstoneState;
        if (this.redstoneState && this.currentLevel <= this.offWhenBelow) {
            this.redstoneState = false;
        } else if (!this.redstoneState && this.currentLevel >= this.onWhenAbove) {
            this.redstoneState = true;
        }
        boolean update = previouslyPowered != this.redstoneState;
        int displayLevel = 0;
        if (this.currentLevel > 0.0f) {
            displayLevel = (int)(this.currentLevel * 6.0f);
        }
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)StockpileSwitchBlock.INDICATOR, (Comparable)Integer.valueOf(displayLevel)), update ? 3 : 2);
        if (update) {
            this.scheduleBlockTick();
        }
        if (changed || update) {
            this.sendData();
        }
    }

    protected void scheduleBlockTick() {
        Block block;
        TickList blockTicks = this.f_58857_.m_6219_();
        if (!blockTicks.m_5913_(this.f_58858_, (Object)(block = this.m_58900_().m_60734_()))) {
            blockTicks.m_7663_(this.f_58858_, (Object)block, 2, TickPriority.NORMAL);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateCurrentLevel();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FilteredDetectorFilterSlot()).moveText(new Vec3(0.0, 5.0, 0.0)).withCallback($ -> this.updateCurrentLevel());
        behaviours.add(this.filtering);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = CapManipulationBehaviourBase.InterfaceProvider.towardBlockFacing();
        this.observedInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    public float getLevelForDisplay() {
        return this.currentLevel == -1.0f ? 0.0f : this.currentLevel;
    }

    public boolean getState() {
        return this.redstoneState;
    }

    public boolean shouldBePowered() {
        return this.inverted != this.redstoneState;
    }

    public void updatePowerAfterDelay() {
        this.poweredAfterDelay = this.shouldBePowered();
        this.f_58857_.m_6289_(this.f_58858_, this.m_58900_().m_60734_());
    }

    public boolean isPowered() {
        return this.poweredAfterDelay;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (inverted == this.inverted) {
            return;
        }
        this.inverted = inverted;
        this.updatePowerAfterDelay();
    }
}

