/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.simibubi.create.content.logistics.item.filter.AbstractFilterContainer;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterContainer;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class FilterScreenPacket
extends SimplePacketBase {
    private final Option option;
    private final CompoundTag data;

    public FilterScreenPacket(Option option) {
        this(option, new CompoundTag());
    }

    public FilterScreenPacket(Option option, CompoundTag data) {
        this.option = option;
        this.data = data;
    }

    public FilterScreenPacket(FriendlyByteBuf buffer) {
        this.option = Option.values()[buffer.readInt()];
        this.data = buffer.m_130260_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.option.ordinal());
        buffer.m_130079_(this.data);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            AbstractFilterContainer c;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (player.f_36096_ instanceof FilterContainer) {
                c = (FilterContainer)player.f_36096_;
                if (this.option == Option.WHITELIST) {
                    ((FilterContainer)c).blacklist = false;
                }
                if (this.option == Option.BLACKLIST) {
                    ((FilterContainer)c).blacklist = true;
                }
                if (this.option == Option.RESPECT_DATA) {
                    ((FilterContainer)c).respectNBT = true;
                }
                if (this.option == Option.IGNORE_DATA) {
                    ((FilterContainer)c).respectNBT = false;
                }
                if (this.option == Option.UPDATE_FILTER_ITEM) {
                    ((FilterContainer)c).ghostInventory.setStackInSlot(this.data.m_128451_("Slot"), ItemStack.m_41712_((CompoundTag)this.data.m_128469_("Item")));
                }
            }
            if (player.f_36096_ instanceof AttributeFilterContainer) {
                c = (AttributeFilterContainer)player.f_36096_;
                if (this.option == Option.WHITELIST) {
                    ((AttributeFilterContainer)c).whitelistMode = AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ;
                }
                if (this.option == Option.WHITELIST2) {
                    ((AttributeFilterContainer)c).whitelistMode = AttributeFilterContainer.WhitelistMode.WHITELIST_CONJ;
                }
                if (this.option == Option.BLACKLIST) {
                    ((AttributeFilterContainer)c).whitelistMode = AttributeFilterContainer.WhitelistMode.BLACKLIST;
                }
                if (this.option == Option.ADD_TAG) {
                    ((AttributeFilterContainer)c).appendSelectedAttribute(ItemAttribute.fromNBT(this.data), false);
                }
                if (this.option == Option.ADD_INVERTED_TAG) {
                    ((AttributeFilterContainer)c).appendSelectedAttribute(ItemAttribute.fromNBT(this.data), true);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static enum Option {
        WHITELIST,
        WHITELIST2,
        BLACKLIST,
        RESPECT_DATA,
        IGNORE_DATA,
        UPDATE_FILTER_ITEM,
        ADD_TAG,
        ADD_INVERTED_TAG;

    }
}

