/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantAttribute
implements ItemAttribute {
    public static final EnchantAttribute EMPTY = new EnchantAttribute(null);
    private final Enchantment enchantment;

    public EnchantAttribute(@Nullable Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return EnchantmentHelper.m_44831_((ItemStack)itemStack).containsKey(this.enchantment);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        return EnchantmentHelper.m_44831_((ItemStack)itemStack).keySet().stream().map(EnchantAttribute::new).collect(Collectors.toList());
    }

    @Override
    public String getTranslationKey() {
        return "has_enchant";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.enchantment != null) {
            parameter = new TranslatableComponent(this.enchantment.m_44704_()).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public void writeNBT(CompoundTag nbt) {
        if (this.enchantment == null) {
            return;
        }
        ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)this.enchantment);
        if (id == null) {
            return;
        }
        nbt.m_128359_("id", id.toString());
    }

    @Override
    public ItemAttribute readNBT(CompoundTag nbt) {
        return nbt.m_128441_("id") ? new EnchantAttribute((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)nbt.m_128461_("id")))) : EMPTY;
    }
}

