/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class ShulkerFillLevelAttribute
implements ItemAttribute {
    public static final ShulkerFillLevelAttribute EMPTY = new ShulkerFillLevelAttribute(null);
    private final ShulkerLevels levels;

    public ShulkerFillLevelAttribute(ShulkerLevels levels) {
        this.levels = levels;
    }

    @Override
    public boolean appliesTo(ItemStack stack) {
        return this.levels != null && this.levels.canApply(stack);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack stack) {
        return Arrays.stream(ShulkerLevels.values()).filter(shulkerLevels -> shulkerLevels.canApply(stack)).map(ShulkerFillLevelAttribute::new).collect(Collectors.toList());
    }

    @Override
    public String getTranslationKey() {
        return "shulker_level";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.levels != null) {
            parameter = Lang.translate("item_attributes." + this.getTranslationKey() + "." + this.levels.key, new Object[0]).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public void writeNBT(CompoundTag nbt) {
        if (this.levels != null) {
            nbt.m_128359_("id", this.levels.key);
        }
    }

    @Override
    public ItemAttribute readNBT(CompoundTag nbt) {
        return nbt.m_128441_("id") ? new ShulkerFillLevelAttribute(ShulkerLevels.fromKey(nbt.m_128461_("id"))) : EMPTY;
    }

    static enum ShulkerLevels {
        EMPTY("empty", amount -> amount == 0),
        PARTIAL("partial", amount -> amount > 0 && amount < Integer.MAX_VALUE),
        FULL("full", amount -> amount == Integer.MAX_VALUE);

        private final Predicate<Integer> requiredSize;
        private final String key;

        private ShulkerLevels(String key, Predicate<Integer> requiredSize) {
            this.key = key;
            this.requiredSize = requiredSize;
        }

        @Nullable
        public static ShulkerLevels fromKey(String key) {
            return Arrays.stream(ShulkerLevels.values()).filter(shulkerLevels -> shulkerLevels.key.equals(key)).findFirst().orElse(null);
        }

        private static boolean isShulker(ItemStack stack) {
            return Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock;
        }

        public boolean canApply(ItemStack testStack) {
            if (!ShulkerLevels.isShulker(testStack)) {
                return false;
            }
            CompoundTag compoundnbt = testStack.m_41737_("BlockEntityTag");
            if (compoundnbt == null) {
                return this.requiredSize.test(0);
            }
            if (compoundnbt.m_128425_("LootTable", 8)) {
                return false;
            }
            if (compoundnbt.m_128425_("Items", 9)) {
                int rawSize = compoundnbt.m_128437_("Items", 10).size();
                if (rawSize < 27) {
                    return this.requiredSize.test(rawSize);
                }
                NonNullList inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundnbt, (NonNullList)inventory);
                boolean isFull = inventory.stream().allMatch(itemStack -> !itemStack.m_41619_() && itemStack.m_41613_() == itemStack.m_41741_());
                return this.requiredSize.test(isFull ? Integer.MAX_VALUE : rawSize);
            }
            return this.requiredSize.test(0);
        }
    }
}

