/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SchematicRenderer {
    private final Map<RenderType, SuperByteBuffer> bufferCache = new HashMap<RenderType, SuperByteBuffer>(SchematicRenderer.getLayerCount());
    private final Set<RenderType> usedBlockRenderLayers = new HashSet<RenderType>(SchematicRenderer.getLayerCount());
    private final Set<RenderType> startedBufferBuilders = new HashSet<RenderType>(SchematicRenderer.getLayerCount());
    private boolean active;
    private boolean changed = false;
    protected SchematicWorld schematic;
    private BlockPos anchor;

    public void display(SchematicWorld world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.active = true;
        this.changed = true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void update() {
        this.changed = true;
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || !this.changed) {
            return;
        }
        this.redraw(mc);
        this.changed = false;
    }

    public void render(PoseStack ms, SuperRenderTypeBuffer buffer) {
        if (!this.active) {
            return;
        }
        buffer.m_6299_(RenderType.m_110451_());
        for (RenderType layer : RenderType.m_110506_()) {
            if (!this.usedBlockRenderLayers.contains(layer)) continue;
            SuperByteBuffer superByteBuffer = this.bufferCache.get(layer);
            superByteBuffer.renderInto(ms, buffer.m_6299_(layer));
        }
        TileEntityRenderHelper.renderTileEntities(this.schematic, this.schematic.getRenderedTileEntities(), ms, buffer);
    }

    protected void redraw(Minecraft minecraft) {
        this.usedBlockRenderLayers.clear();
        this.startedBufferBuilders.clear();
        SchematicWorld blockAccess = this.schematic;
        BlockRenderDispatcher blockRendererDispatcher = minecraft.m_91289_();
        LinkedList blockstates = new LinkedList();
        HashMap buffers = new HashMap();
        PoseStack ms = new PoseStack();
        BlockPos.m_121919_((BoundingBox)blockAccess.getBounds()).forEach(localPos -> {
            ms.m_85836_();
            TransformStack.cast((PoseStack)ms).translate((Vec3i)localPos);
            BlockPos pos = localPos.m_141952_((Vec3i)this.anchor);
            BlockState state = blockAccess.m_8055_(pos);
            for (RenderType blockRenderLayer : RenderType.m_110506_()) {
                BlockEntity tileEntity;
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)blockRenderLayer)) continue;
                ForgeHooksClient.setRenderLayer((RenderType)blockRenderLayer);
                if (!buffers.containsKey(blockRenderLayer)) {
                    buffers.put(blockRenderLayer, new BufferBuilder(DefaultVertexFormat.f_85811_.m_86017_()));
                }
                BufferBuilder bufferBuilder = (BufferBuilder)buffers.get(blockRenderLayer);
                if (this.startedBufferBuilders.add(blockRenderLayer)) {
                    bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                }
                if (blockRendererDispatcher.renderBatched(state, pos, (BlockAndTintGetter)blockAccess, ms, (VertexConsumer)bufferBuilder, true, minecraft.f_91073_.f_46441_, (IModelData)((tileEntity = blockAccess.m_7702_((BlockPos)localPos)) != null ? tileEntity.getModelData() : EmptyModelData.INSTANCE))) {
                    this.usedBlockRenderLayers.add(blockRenderLayer);
                }
                blockstates.add(state);
            }
            ForgeHooksClient.setRenderLayer(null);
            ms.m_85849_();
        });
        for (RenderType layer : RenderType.m_110506_()) {
            if (!this.startedBufferBuilders.contains(layer)) continue;
            BufferBuilder buf = (BufferBuilder)buffers.get(layer);
            buf.m_85721_();
            this.bufferCache.put(layer, new SuperByteBuffer(buf));
        }
    }

    private static int getLayerCount() {
        return RenderType.m_110506_().size();
    }
}

