/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.packet;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.schematics.filtering.SchematicInstances;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SchematicSyncPacket
extends SimplePacketBase {
    public int slot;
    public boolean deployed;
    public BlockPos anchor;
    public Rotation rotation;
    public Mirror mirror;

    public SchematicSyncPacket(int slot, StructurePlaceSettings settings, BlockPos anchor, boolean deployed) {
        this.slot = slot;
        this.deployed = deployed;
        this.anchor = anchor;
        this.rotation = settings.m_74404_();
        this.mirror = settings.m_74401_();
    }

    public SchematicSyncPacket(FriendlyByteBuf buffer) {
        this.slot = buffer.m_130242_();
        this.deployed = buffer.readBoolean();
        this.anchor = buffer.m_130135_();
        this.rotation = (Rotation)buffer.m_130066_(Rotation.class);
        this.mirror = (Mirror)buffer.m_130066_(Mirror.class);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.slot);
        buffer.writeBoolean(this.deployed);
        buffer.m_130064_(this.anchor);
        buffer.m_130068_((Enum)this.rotation);
        buffer.m_130068_((Enum)this.mirror);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = ItemStack.f_41583_;
            stack = this.slot == -1 ? player.m_21205_() : player.m_150109_().m_8020_(this.slot);
            if (!AllItems.SCHEMATIC.isIn(stack)) {
                return;
            }
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("Deployed", this.deployed);
            tag.m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)this.anchor));
            tag.m_128359_("Rotation", this.rotation.name());
            tag.m_128359_("Mirror", this.mirror.name());
            SchematicInstances.clearHash(stack);
        });
        context.get().setPacketHandled(true);
    }
}

