/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.simibubi.create.foundation.block.render.IBlockVertexColor;
import com.simibubi.create.foundation.block.render.QuadHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ColoredVertexModel
extends BakedModelWrapper<BakedModel> {
    private static final ModelProperty<BlockPos> POSITION_PROPERTY = new ModelProperty();
    private IBlockVertexColor color;

    public ColoredVertexModel(BakedModel originalModel, IBlockVertexColor color) {
        super(originalModel);
        this.color = color;
    }

    public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData tileData) {
        return new ModelDataMap.Builder().withInitial(POSITION_PROPERTY, (Object)pos).build();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData);
        if (quads.isEmpty()) {
            return quads;
        }
        if (!extraData.hasProperty(POSITION_PROPERTY)) {
            return quads;
        }
        BlockPos data = (BlockPos)extraData.getData(POSITION_PROPERTY);
        quads = new ArrayList<BakedQuad>(quads);
        VertexFormat format = DefaultVertexFormat.f_85811_;
        int colorIndex = 0;
        for (int elementId = 0; elementId < format.m_86023_().size(); ++elementId) {
            VertexFormatElement element = (VertexFormatElement)format.m_86023_().get(elementId);
            if (element.m_86048_() != VertexFormatElement.Usage.COLOR) continue;
            colorIndex = elementId;
        }
        int colorOffset = format.getOffset(colorIndex) / 4;
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < vertexData.length; vertex += format.m_86017_()) {
                int color;
                float x = Float.intBitsToFloat(vertexData[vertex]);
                float y = Float.intBitsToFloat(vertexData[vertex + 1]);
                float z = Float.intBitsToFloat(vertexData[vertex + 2]);
                vertexData[vertex + colorOffset] = color = this.color.getColor(x + (float)data.m_123341_(), y + (float)data.m_123342_(), z + (float)data.m_123343_());
            }
            quads.set(i, newQuad);
        }
        return quads;
    }
}

