/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"Create/ChunkUtil");
    final EnumSet<Heightmap.Types> POST_FEATURES = EnumSet.of(Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE, Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    private final List<Long> markedChunks;
    private final List<Long> interestingChunks;

    public ChunkUtil() {
        LOGGER.debug("Chunk Util constructed");
        this.markedChunks = new LinkedList<Long>();
        this.interestingChunks = new LinkedList<Long>();
    }

    public void init() {
        ChunkStatus.f_62326_ = new ChunkStatus("full", ChunkStatus.f_62325_, 0, this.POST_FEATURES, ChunkStatus.ChunkType.LEVELCHUNK, (_0, _1, _2, _3, _4, _5, future, _7, chunk) -> (CompletableFuture)future.apply(chunk), (_0, _1, _2, _3, future, chunk) -> {
            if (this.markedChunks.contains(chunk.m_7697_().m_45588_())) {
                LOGGER.debug("trying to load unforced chunk " + chunk.m_7697_().toString() + ", returning chunk loading error");
                return ChunkHolder.f_139996_;
            }
            return (CompletableFuture)future.apply(chunk);
        });
    }

    public boolean reloadChunk(ServerChunkCache provider, ChunkPos pos) {
        ChunkHolder holder = (ChunkHolder)provider.f_8325_.f_140129_.remove(pos.m_45588_());
        provider.f_8325_.f_140140_ = true;
        if (holder != null) {
            provider.f_8325_.f_140131_.put(pos.m_45588_(), (Object)holder);
            provider.f_8325_.m_140181_(pos.m_45588_(), holder);
            return true;
        }
        return false;
    }

    public boolean unloadChunk(ServerChunkCache provider, ChunkPos pos) {
        this.interestingChunks.add(pos.m_45588_());
        this.markedChunks.add(pos.m_45588_());
        return this.reloadChunk(provider, pos);
    }

    public int clear(ServerChunkCache provider) {
        LinkedList<Long> copy = new LinkedList<Long>(this.markedChunks);
        int size = this.markedChunks.size();
        this.markedChunks.clear();
        copy.forEach(l -> this.reForce(provider, new ChunkPos(l.longValue())));
        return size;
    }

    public void reForce(ServerChunkCache provider, ChunkPos pos) {
        provider.m_6692_(pos, true);
        provider.m_6692_(pos, false);
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        if (this.interestingChunks.contains(event.getChunk().m_7697_().m_45588_())) {
            LOGGER.info("Interesting Chunk Unload: " + event.getChunk().m_7697_().toString());
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        ChunkPos pos = event.getChunk().m_7697_();
        if (this.interestingChunks.contains(pos.m_45588_())) {
            LOGGER.info("Interesting Chunk Load: " + pos.toString());
            if (!this.markedChunks.contains(pos.m_45588_())) {
                this.interestingChunks.remove(pos.m_45588_());
            }
        }
    }
}

