/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.instancing.entity.IEntityInstanceFactory;
import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.builders.EntityBuilder;
import com.simibubi.create.repack.registrate.util.OneTimeEventReceiver;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@ParametersAreNonnullByDefault
public class CreateEntityBuilder<T extends Entity, P>
extends EntityBuilder<T, P> {
    @Nullable
    private NonNullSupplier<IEntityInstanceFactory<? super T>> instanceFactory;

    public static <T extends Entity, P> EntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.EntityFactory<T> factory, MobCategory classification) {
        return new CreateEntityBuilder<T, P>(owner, parent, name, callback, factory, classification).defaultLang();
    }

    public CreateEntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.EntityFactory<T> factory, MobCategory classification) {
        super(owner, parent, name, callback, factory, classification);
    }

    public CreateEntityBuilder<T, P> instance(NonNullSupplier<IEntityInstanceFactory<? super T>> instanceFactory) {
        if (this.instanceFactory == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerInstance);
        }
        this.instanceFactory = instanceFactory;
        return this;
    }

    protected void registerInstance() {
        OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, $ -> {
            NonNullSupplier<IEntityInstanceFactory<T>> instanceFactory = this.instanceFactory;
            if (instanceFactory != null) {
                InstancedRenderRegistry.getInstance().entity((EntityType)this.getEntry()).factory(instanceFactory.get());
            }
        });
    }
}

