/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.fluids.VirtualFluid;
import com.simibubi.create.content.contraptions.relays.encased.CasingConnectivity;
import com.simibubi.create.foundation.block.connected.CTModel;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.render.ColoredVertexModel;
import com.simibubi.create.foundation.block.render.IBlockVertexColor;
import com.simibubi.create.foundation.data.CreateEntityBuilder;
import com.simibubi.create.foundation.data.CreateTileEntityBuilder;
import com.simibubi.create.foundation.data.VirtualFluidBuilder;
import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.Builder;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.builders.FluidBuilder;
import com.simibubi.create.repack.registrate.util.NonNullLazyValue;
import com.simibubi.create.repack.registrate.util.entry.RegistryEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiFunction;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CreateRegistrate
extends AbstractRegistrate<CreateRegistrate> {
    private static Map<RegistryEntry<?>, AllSections> sectionLookup = new IdentityHashMap();
    private AllSections section;

    protected CreateRegistrate(String modid) {
        super(modid);
    }

    public static NonNullLazyValue<CreateRegistrate> lazy(String modid) {
        return new NonNullLazyValue<CreateRegistrate>(() -> (CreateRegistrate)new CreateRegistrate(modid).registerEventListeners(FMLJavaModLoadingContext.get().getModEventBus()));
    }

    public CreateRegistrate startSection(AllSections section) {
        this.section = section;
        return this;
    }

    public AllSections currentSection() {
        return this.section;
    }

    @Override
    protected <R extends IForgeRegistryEntry<R>, T extends R> RegistryEntry<T> accept(String name, Class<? super R> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
        RegistryEntry<? extends T> ret = super.accept(name, type, builder, creator, entryFactory);
        sectionLookup.put(ret, this.currentSection());
        return ret;
    }

    public void addToSection(RegistryEntry<?> entry, AllSections section) {
        sectionLookup.put(entry, section);
    }

    public AllSections getSection(RegistryEntry<?> entry) {
        return sectionLookup.getOrDefault(entry, AllSections.UNASSIGNED);
    }

    public AllSections getSection(IForgeRegistryEntry<?> entry) {
        return sectionLookup.entrySet().stream().filter(e -> ((RegistryEntry)e.getKey()).get() == entry).map(Map.Entry::getValue).findFirst().orElse(AllSections.UNASSIGNED);
    }

    public <R extends IForgeRegistryEntry<R>> Collection<RegistryEntry<R>> getAll(AllSections section, Class<? super R> registryType) {
        return this.getAll(registryType).stream().filter(e -> this.getSection((RegistryEntry<?>)e) == section).collect(Collectors.toList());
    }

    @Override
    public <T extends BlockEntity> CreateTileEntityBuilder<T, CreateRegistrate> tileEntity(String name, BlockEntityFactory<T> factory) {
        return this.tileEntity((CreateRegistrate)this.self(), name, factory);
    }

    @Override
    public <T extends BlockEntity, P> CreateTileEntityBuilder<T, P> tileEntity(P parent, String name, BlockEntityFactory<T> factory) {
        return (CreateTileEntityBuilder)this.entry(name, callback -> CreateTileEntityBuilder.create(this, parent, name, callback, factory::createWithReversedParams));
    }

    @Override
    public <T extends Entity> CreateEntityBuilder<T, CreateRegistrate> entity(String name, EntityType.EntityFactory<T> factory, MobCategory classification) {
        return this.entity((CreateRegistrate)this.self(), name, (EntityType.EntityFactory)factory, classification);
    }

    @Override
    public <T extends Entity, P> CreateEntityBuilder<T, P> entity(P parent, String name, EntityType.EntityFactory<T> factory, MobCategory classification) {
        return (CreateEntityBuilder)this.entry(name, callback -> CreateEntityBuilder.create(this, parent, name, callback, factory, classification));
    }

    public <T extends Block> BlockBuilder<T, CreateRegistrate> paletteStoneBlock(String name, NonNullFunction<BlockBehaviour.Properties, T> factory, NonNullSupplier<Block> propertiesFrom, boolean worldGenStone) {
        BlockBuilder builder = (BlockBuilder)super.block(name, factory).initialProperties(propertiesFrom).transform(AllTags.pickaxeOnly()).blockstate((c, p) -> {
            String location = "block/palettes/stone_types/" + c.getName();
            p.simpleBlock((Block)c.get(), (ModelFile)p.models().cubeAll(c.getName(), p.modLoc(location)));
        }).item().build();
        return builder;
    }

    public BlockBuilder<Block, CreateRegistrate> paletteStoneBlock(String name, NonNullSupplier<Block> propertiesFrom, boolean worldGenStone) {
        return this.paletteStoneBlock(name, Block::new, propertiesFrom, worldGenStone);
    }

    public <T extends ForgeFlowingFluid> FluidBuilder<T, CreateRegistrate> virtualFluid(String name, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return this.entry(name, c -> new VirtualFluidBuilder((AbstractRegistrate<?>)this.self(), (CreateRegistrate)this.self(), name, (BuilderCallback)c, Create.asResource("fluid/" + name + "_still"), Create.asResource("fluid/" + name + "_flow"), attributesFactory, factory));
    }

    public FluidBuilder<VirtualFluid, CreateRegistrate> virtualFluid(String name) {
        return this.entry(name, c -> new VirtualFluidBuilder<VirtualFluid, CreateRegistrate>((AbstractRegistrate<?>)this.self(), (CreateRegistrate)this.self(), name, (BuilderCallback)c, Create.asResource("fluid/" + name + "_still"), Create.asResource("fluid/" + name + "_flow"), null, VirtualFluid::new));
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, CreateRegistrate> standardFluid(String name) {
        return this.fluid(name, Create.asResource("fluid/" + name + "_still"), Create.asResource("fluid/" + name + "_flow"));
    }

    public FluidBuilder<ForgeFlowingFluid.Flowing, CreateRegistrate> standardFluid(String name, NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
        return this.fluid(name, Create.asResource("fluid/" + name + "_still"), Create.asResource("fluid/" + name + "_flow"), attributesFactory);
    }

    public static <T extends Block> NonNullConsumer<? super T> connectedTextures(ConnectedTextureBehaviour behavior) {
        return entry -> CreateRegistrate.onClient(() -> () -> CreateRegistrate.registerCTBehviour(entry, behavior));
    }

    public static <T extends Block> NonNullConsumer<? super T> casingConnectivity(BiConsumer<T, CasingConnectivity> consumer) {
        return entry -> CreateRegistrate.onClient(() -> () -> CreateRegistrate.registerCasingConnectivity(entry, consumer));
    }

    public static <T extends Block> NonNullConsumer<? super T> blockVertexColors(IBlockVertexColor colorFunc) {
        return entry -> CreateRegistrate.onClient(() -> () -> CreateRegistrate.registerBlockVertexColor(entry, colorFunc));
    }

    public static <T extends Block> NonNullConsumer<? super T> blockModel(Supplier<NonNullFunction<BakedModel, ? extends BakedModel>> func) {
        return entry -> CreateRegistrate.onClient(() -> CreateRegistrate.lambda$blockModel$18(entry, (Supplier)func));
    }

    public static <T extends Item> NonNullConsumer<? super T> itemModel(Supplier<NonNullFunction<BakedModel, ? extends BakedModel>> func) {
        return entry -> CreateRegistrate.onClient(() -> CreateRegistrate.lambda$itemModel$21(entry, (Supplier)func));
    }

    protected static void onClient(Supplier<Runnable> toRun) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, toRun);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerCTBehviour(Block entry, ConnectedTextureBehaviour behavior) {
        CreateClient.MODEL_SWAPPER.getCustomBlockModels().register((Supplier<? extends Block>)entry.delegate, model -> new CTModel((BakedModel)model, behavior));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <T extends Block> void registerCasingConnectivity(T entry, BiConsumer<T, CasingConnectivity> consumer) {
        consumer.accept(entry, CreateClient.CASING_CONNECTIVITY);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerBlockVertexColor(Block entry, IBlockVertexColor colorFunc) {
        CreateClient.MODEL_SWAPPER.getCustomBlockModels().register((Supplier<? extends Block>)entry.delegate, model -> new ColoredVertexModel((BakedModel)model, colorFunc));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerBlockModel(Block entry, Supplier<NonNullFunction<BakedModel, ? extends BakedModel>> func) {
        CreateClient.MODEL_SWAPPER.getCustomBlockModels().register((Supplier<? extends Block>)entry.delegate, func.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerItemModel(Item entry, Supplier<NonNullFunction<BakedModel, ? extends BakedModel>> func) {
        CreateClient.MODEL_SWAPPER.getCustomItemModels().register((Supplier<? extends Item>)entry.delegate, func.get());
    }

    private static /* synthetic */ Runnable lambda$itemModel$21(Item entry, Supplier func) {
        return () -> CreateRegistrate.lambda$itemModel$20(entry, (Supplier)func);
    }

    private static /* synthetic */ void lambda$itemModel$20(Item entry, Supplier func) {
        CreateRegistrate.registerItemModel(entry, func);
    }

    private static /* synthetic */ Runnable lambda$blockModel$18(Block entry, Supplier func) {
        return () -> CreateRegistrate.lambda$blockModel$17(entry, (Supplier)func);
    }

    private static /* synthetic */ void lambda$blockModel$17(Block entry, Supplier func) {
        CreateRegistrate.registerBlockModel(entry, func);
    }

    public static interface BlockEntityFactory<T extends BlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);

        default public T createWithReversedParams(BlockPos pos, BlockState state, BlockEntityType<T> type) {
            return this.create(type, pos, state);
        }
    }
}

