/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instruction;

import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.instruction.WorldModifyInstruction;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileEntityDataInstruction
extends WorldModifyInstruction {
    private boolean redraw;
    private UnaryOperator<CompoundTag> data;
    private Class<? extends BlockEntity> type;

    public TileEntityDataInstruction(Selection selection, Class<? extends BlockEntity> type, UnaryOperator<CompoundTag> data, boolean redraw) {
        super(selection);
        this.type = type;
        this.data = data;
        this.redraw = redraw;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderWorld world = scene.getWorld();
        selection.forEach(pos -> {
            if (!world.getBounds().m_71051_((Vec3i)pos)) {
                return;
            }
            BlockEntity tileEntity = world.m_7702_((BlockPos)pos);
            if (!this.type.isInstance(tileEntity)) {
                return;
            }
            CompoundTag apply = (CompoundTag)this.data.apply(tileEntity.m_6945_(new CompoundTag()));
            if (tileEntity instanceof SyncedTileEntity) {
                ((SyncedTileEntity)tileEntity).readClientUpdate(apply);
            }
            tileEntity.m_142466_(apply);
        });
    }

    @Override
    protected boolean needsRedraw() {
        return this.redraw;
    }
}

