/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.crank.ValveHandleBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderChapter;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.ui.ChapterLabel;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class PonderIndexScreen
extends NavigatableSimiScreen {
    protected final List<PonderChapter> chapters;
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.3;
    protected Rect2i chapterArea;
    protected final List<Item> items;
    private final double itemXmult = 0.5;
    private double itemYmult = 0.75;
    protected Rect2i itemArea;
    private ItemStack hoveredItem = ItemStack.f_41583_;

    public PonderIndexScreen() {
        this.chapters = new ArrayList<PonderChapter>();
        this.items = new ArrayList<Item>();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.chapters.clear();
        this.items.clear();
        PonderRegistry.ALL.keySet().stream().map(key -> {
            Block b;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
            if (item == null && (b = (Block)ForgeRegistries.BLOCKS.getValue(key)) != null) {
                item = b.m_5456_();
            }
            return item;
        }).filter(Objects::nonNull).filter(PonderIndexScreen::exclusions).forEach(this.items::add);
        boolean hasChapters = !this.chapters.isEmpty();
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.chapters.size(), Mth.m_14045_((int)((int)Math.ceil((float)this.chapters.size() / 4.0f)), (int)1, (int)4), 200, 38, 16);
        this.chapterArea = layout.getArea();
        int chapterCenterX = (int)((double)this.f_96543_ * 0.5);
        int chapterCenterY = (int)((double)this.f_96544_ * 0.3);
        for (PonderChapter chapter : this.chapters) {
            ChapterLabel label = new ChapterLabel(chapter, chapterCenterX + layout.getX(), chapterCenterY + layout.getY(), (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(chapter));
            });
            this.m_142416_(label);
            layout.next();
        }
        if (!hasChapters) {
            this.itemYmult = 0.5;
        }
        int maxItemRows = hasChapters ? 4 : 7;
        layout = LayoutHelper.centeredHorizontal(this.items.size(), Mth.m_14045_((int)((int)Math.ceil((float)this.items.size() / 11.0f)), (int)1, (int)maxItemRows), 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.f_96543_ * 0.5);
        int itemCenterY = (int)((double)this.f_96544_ * this.itemYmult);
        for (Item item : this.items) {
            PonderButton b = (PonderButton)((AbstractSimiWidget)new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showing(new ItemStack((ItemLike)item))).withCallback((x, y) -> {
                if (!PonderRegistry.ALL.containsKey(item.getRegistryName())) {
                    return;
                }
                this.centerScalingOn((int)x, (int)y);
                ScreenOpener.transitionTo(PonderUI.of(new ItemStack((ItemLike)item)));
            });
            this.m_142416_(b);
            layout.next();
        }
    }

    @Override
    protected void initBackTrackIcon(PonderButton backTrack) {
        backTrack.showing(AllItems.WRENCH.asStack());
    }

    private static boolean exclusions(Item item) {
        Block block;
        return !(item instanceof BlockItem) || !((block = ((BlockItem)item).m_40614_()) instanceof ValveHandleBlock) || AllBlocks.COPPER_VALVE_HANDLE.is(item);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.f_41583_;
        Window w = this.f_96541_.m_91268_();
        double mouseX = this.f_96541_.f_91067_.m_91589_() * (double)w.m_85445_() / (double)w.m_85443_();
        double mouseY = this.f_96541_.f_91067_.m_91594_() * (double)w.m_85446_() / (double)w.m_85444_();
        for (GuiEventListener child : this.m_6702_()) {
            PonderButton button;
            GuiEventListener guiEventListener = child;
            if (!(guiEventListener instanceof PonderButton) || !(button = (PonderButton)guiEventListener).m_5953_(mouseX, mouseY)) continue;
            this.hoveredItem = button.getItem();
        }
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = (int)((double)this.f_96543_ * 0.5);
        int y = (int)((double)this.f_96544_ * 0.3);
        if (!this.chapters.isEmpty()) {
            ms.m_85836_();
            ms.m_85837_((double)x, (double)y, 0.0);
            UIRenderHelper.streak(ms, 0.0f, this.chapterArea.m_110085_() - 10, this.chapterArea.m_110086_() - 20, 20, 220);
            this.f_96547_.m_92883_(ms, "Topics to Ponder about", (float)(this.chapterArea.m_110085_() - 5), (float)(this.chapterArea.m_110086_() - 25), Theme.i(Theme.Key.TEXT));
            ms.m_85849_();
        }
        x = (int)((double)this.f_96543_ * 0.5);
        y = (int)((double)this.f_96544_ * this.itemYmult);
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, 0.0);
        UIRenderHelper.streak(ms, 0.0f, this.itemArea.m_110085_() - 10, this.itemArea.m_110086_() - 20, 20, 220);
        this.f_96547_.m_92883_(ms, "Items to inspect", (float)(this.itemArea.m_110085_() - 5), (float)(this.itemArea.m_110086_() - 25), Theme.i(Theme.Key.TEXT));
        ms.m_85849_();
    }

    @Override
    protected void renderWindowForeground(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredItem.m_41619_()) {
            return;
        }
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, 200.0);
        this.m_6057_(ms, this.hoveredItem, mouseX, mouseY);
        ms.m_85849_();
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return other instanceof PonderIndexScreen;
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean m_7043_() {
        return true;
    }
}

