/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileEntityRenderHelper {
    public static void renderTileEntities(Level world, Iterable<BlockEntity> customRenderTEs, PoseStack ms, MultiBufferSource buffer) {
        TileEntityRenderHelper.renderTileEntities(world, null, customRenderTEs, ms, null, buffer);
    }

    public static void renderTileEntities(Level world, Iterable<BlockEntity> customRenderTEs, PoseStack ms, MultiBufferSource buffer, float pt) {
        TileEntityRenderHelper.renderTileEntities(world, null, customRenderTEs, ms, null, buffer, pt);
    }

    public static void renderTileEntities(Level world, @Nullable PlacementSimulationWorld renderWorld, Iterable<BlockEntity> customRenderTEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer) {
        TileEntityRenderHelper.renderTileEntities(world, renderWorld, customRenderTEs, ms, lightTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderTileEntities(Level world, @Nullable PlacementSimulationWorld renderWorld, Iterable<BlockEntity> customRenderTEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer, float pt) {
        Iterator<BlockEntity> iterator = customRenderTEs.iterator();
        while (iterator.hasNext()) {
            BlockEntity tileEntity = iterator.next();
            if (Backend.getInstance().canUseInstancing((Level)renderWorld) && InstancedRenderRegistry.getInstance().shouldSkipRender(tileEntity)) continue;
            BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(tileEntity);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            BlockPos pos = tileEntity.m_58899_();
            ms.m_85836_();
            TransformStack.cast((PoseStack)ms).translate((Vec3i)pos);
            try {
                BlockPos lightPos;
                if (lightTransform != null) {
                    Vector4f lightVec = new Vector4f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f, 1.0f);
                    lightVec.m_123607_(lightTransform);
                    lightPos = new BlockPos((double)lightVec.m_123601_(), (double)lightVec.m_123615_(), (double)lightVec.m_123616_());
                } else {
                    lightPos = pos;
                }
                int worldLight = TileEntityRenderHelper.getCombinedLight(world, lightPos, renderWorld, pos);
                renderer.m_6922_(tileEntity, pt, ms, buffer, worldLight, OverlayTexture.f_118083_);
            }
            catch (Exception e) {
                iterator.remove();
                String message = "TileEntity " + tileEntity.m_58903_().getRegistryName().toString() + " didn't want to render while moved.\n";
                if (((Boolean)AllConfigs.CLIENT.explainRenderErrors.get()).booleanValue()) {
                    Create.LOGGER.error(message, (Throwable)e);
                }
                Create.LOGGER.error(message);
            }
            ms.m_85849_();
        }
    }

    public static int getCombinedLight(Level world, BlockPos worldPos, @Nullable PlacementSimulationWorld renderWorld, BlockPos renderWorldPos) {
        int worldLight = LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)worldPos);
        if (renderWorld != null) {
            int renderWorldLight = LevelRenderer.m_109541_((BlockAndTintGetter)renderWorld, (BlockPos)renderWorldPos);
            return SuperByteBuffer.maxLight(worldLight, renderWorldLight);
        }
        return worldLight;
    }
}

